/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.validation;

import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.internal.ui.validation.Activator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ValidationLabelProvider
implements ITableLabelProvider {
    private final ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
    private final AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
    private final Image warning;
    private final Image error = Activator.getImageDescriptor("icons/error_decorate.png").createImage();

    public ValidationLabelProvider() {
        this.warning = Activator.getImageDescriptor("icons/warning_decorate.png").createImage();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.composedAdapterFactory.dispose();
        this.labelProvider.dispose();
        this.error.dispose();
        this.warning.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Diagnostic diagnostic = (Diagnostic)element;
        switch (columnIndex) {
            case 0: {
                return this.getImageForSeverity(diagnostic.getSeverity());
            }
        }
        return null;
    }

    private Image getImageForSeverity(int severity) {
        switch (severity) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 2: {
                return this.warning;
            }
            case 4: {
                return this.error;
            }
            case 8: {
                return null;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Diagnostic diagnostic = (Diagnostic)element;
        List data = diagnostic.getData();
        switch (columnIndex) {
            case 0: {
                return diagnostic.getMessage();
            }
            case 1: {
                if (data.size() > 0) {
                    return this.labelProvider.getText(data.get(0));
                }
                return null;
            }
            case 2: {
                if (data.size() > 1) {
                    return this.getFeatureName((EObject)data.get(0), (EStructuralFeature)data.get(1));
                }
                return null;
            }
        }
        return null;
    }

    protected String getFeatureName(EObject owner, EStructuralFeature feature) {
        String result = feature.getName();
        IItemLabelProvider provider = (IItemLabelProvider)this.composedAdapterFactory.adapt((Notifier)owner, IItemLabelProvider.class);
        if (provider instanceof ResourceLocator) {
            EClass eClass = feature.getEContainingClass();
            String key = String.format("_UI_%s_%s_feature", eClass.getName(), result);
            try {
                String l10nResult = ((ResourceLocator)provider).getString(key);
                if (l10nResult != null) {
                    result = l10nResult;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return result;
    }
}

