/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.section.swt;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.internal.section.ui.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.section.model.VSection;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.swt.core.AbstractAdditionalSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public abstract class AbstractSectionSWTRenderer
extends AbstractSWTRenderer<VSection> {
    public AbstractSectionSWTRenderer(VSection vElement, ViewModelContext viewContext, ReportService reportService) {
        super((VElement)vElement, viewContext, reportService);
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (cell.getRenderer() == this) {
            if (cell.getColumn() == 0) {
                return this.createFirstColumn(parent);
            }
            if (cell.getColumn() < 0) {
                return this.renderEmpty(parent);
            }
            return this.renderChild(parent, (VContainedElement)((VSection)this.getVElement()).getChildren().get(cell.getColumn() - 1));
        }
        return ((AbstractSWTRenderer)cell.getRenderer()).render(cell, parent);
    }

    protected abstract Control createFirstColumn(Composite var1);

    private Control renderEmpty(Composite parent) {
        return new Label(parent, 0);
    }

    private Control renderChild(Composite parent, VContainedElement child) throws NoRendererFoundException {
        AbstractSWTRenderer renderer;
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setBackground(parent.getBackground());
        LinkedHashMap elementRendererMap = new LinkedHashMap();
        SWTGridDescription maximalGridDescription = null;
        LinkedHashMap<VContainedElement, SWTGridDescription> rowGridDescription = new LinkedHashMap<VContainedElement, SWTGridDescription>();
        LinkedHashMap<VContainedElement, SWTGridDescription> controlGridDescription = new LinkedHashMap<VContainedElement, SWTGridDescription>();
        if (VControl.class.isInstance(child)) {
            if (((VControl)VControl.class.cast(child)).getDomainModelReference() == null) {
                return columnComposite;
            }
            try {
                Activator.getDefault().getEMFFormsDatabinding().getValueProperty(((VControl)VControl.class.cast(child)).getDomainModelReference(), this.getViewModelContext().getDomainModel());
            }
            catch (DatabindingFailedException ex) {
                Activator.getDefault().getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                return columnComposite;
            }
        }
        try {
            renderer = this.getEMFFormsRendererFactory().getRendererInstance((VElement)child, this.getViewModelContext());
        }
        catch (EMFFormsNoRendererException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return columnComposite;
        }
        Collection additionalRenderers = this.getEMFFormsRendererFactory().getAdditionalRendererInstances((VElement)child, this.getViewModelContext());
        SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
        controlGridDescription.put(child, gridDescription);
        for (AbstractAdditionalSWTRenderer additionalRenderer : additionalRenderers) {
            gridDescription = additionalRenderer.getGridDescription(gridDescription);
        }
        rowGridDescription.put(child, gridDescription);
        maximalGridDescription = gridDescription;
        LinkedHashSet<AbstractSWTRenderer> allRenderer = new LinkedHashSet<AbstractSWTRenderer>();
        allRenderer.add(renderer);
        allRenderer.addAll(additionalRenderers);
        elementRendererMap.put(child, allRenderer);
        if (maximalGridDescription == null) {
            return columnComposite;
        }
        columnComposite.setLayout(this.getLayout(maximalGridDescription.getColumns(), false));
        try {
            SWTGridDescription gridDescription2 = (SWTGridDescription)rowGridDescription.get(child);
            if (gridDescription2 == null) {
                return columnComposite;
            }
            for (SWTGridCell childGridCell : gridDescription2.getGrid()) {
                Control control = ((AbstractSWTRenderer)childGridCell.getRenderer()).render(childGridCell, columnComposite);
                if (control == null) continue;
                this.setLayoutDataForControl(childGridCell, (SWTGridDescription)controlGridDescription.get(child), gridDescription2, maximalGridDescription, ((AbstractSWTRenderer)childGridCell.getRenderer()).getVElement(), control);
            }
            for (SWTGridCell childGridCell : gridDescription2.getGrid()) {
                ((AbstractSWTRenderer)childGridCell.getRenderer()).finalizeRendering(columnComposite);
            }
        }
        catch (NoPropertyDescriptorFoundExeption ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return columnComposite;
        }
        return columnComposite;
    }

    private Layout getLayout(int numControls, boolean equalWidth) {
        return LayoutProviderHelper.getColumnLayout((int)numControls, (boolean)equalWidth);
    }

    protected void adjustLayoutData(boolean collapsed) {
        boolean visible = collapsed;
        for (SWTGridCell gridCell : this.getControls().keySet()) {
            GridData gridData;
            Object layoutData = ((Control)this.getControls().get(gridCell)).getLayoutData();
            if (GridData.class.isInstance(layoutData) && (gridData = (GridData)layoutData) != null) {
                gridData.exclude = !visible;
            }
            ((Control)this.getControls().get(gridCell)).setVisible(visible);
        }
    }

    protected EMFFormsRendererFactory getEMFFormsRendererFactory() {
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsRendererFactory.class);
        EMFFormsRendererFactory rendererFactory = (EMFFormsRendererFactory)bundleContext.getService(serviceReference);
        bundleContext.ungetService(serviceReference);
        return rendererFactory;
    }

    private void setLayoutDataForControl(SWTGridCell gridCell, SWTGridDescription gridDescription, SWTGridDescription currentRowGridDescription, SWTGridDescription fullGridDescription, VElement vElement, Control control) {
        control.setLayoutData(LayoutProviderHelper.getLayoutData((SWTGridCell)gridCell, (SWTGridDescription)gridDescription, (SWTGridDescription)currentRowGridDescription, (SWTGridDescription)fullGridDescription, (VElement)vElement, (EObject)this.getViewModelContext().getDomainModel(), (Control)control));
    }

    protected abstract void initCollapseState();
}

