/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;

public final class XPathPopulationUtil {
    private static final String XPATH_WILDCARD = "*";
    private static final String XPATH_ATTR_HEADER_WITH_SLASH = "/@";
    private static final String XPATH_ATTR_HEADER_WITH_SQUARE_PATTERN = "\\Q[@\\E";
    private static final String EMPTY_STRING = "";
    private static final String FORWARD_SLASH = "/";

    public static List populateRootPath(String absolutePath) {
        assert (absolutePath != null);
        ArrayList<String> result = new ArrayList<String>();
        result.add(absolutePath);
        if (absolutePath.startsWith(FORWARD_SLASH)) {
            absolutePath = absolutePath.replaceFirst(FORWARD_SLASH, EMPTY_STRING);
        }
        String[] xPathFrags = absolutePath.split(FORWARD_SLASH);
        int i = 1;
        while (i < xPathFrags.length) {
            String temp = "//";
            temp = XPathPopulationUtil.addXPathFragsToAString(xPathFrags, i, temp);
            result.add(temp);
            ++i;
        }
        return result;
    }

    public static List getPathList(String absolutePath) {
        String[] xPathFrags;
        if (absolutePath == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(absolutePath);
        if (absolutePath.startsWith(FORWARD_SLASH)) {
            absolutePath = absolutePath.replaceFirst(FORWARD_SLASH, EMPTY_STRING);
        }
        if ((xPathFrags = absolutePath.split(FORWARD_SLASH)).length > 0) {
            String temp = "//";
            temp = XPathPopulationUtil.addXPathFragsToAString(xPathFrags, xPathFrags.length - 1, temp);
            result.add(temp);
        }
        return result;
    }

    private static String addXPathFragsToAString(String[] xPathFrags, int i, String s) {
        int j = i;
        while (j < xPathFrags.length) {
            s = j < xPathFrags.length - 1 ? String.valueOf(s) + xPathFrags[j] + FORWARD_SLASH : String.valueOf(s) + xPathFrags[j];
            ++j;
        }
        return s;
    }

    public static String populateColumnPath(String rootPath, String columnPath) {
        assert (rootPath != null);
        assert (columnPath != null);
        if ((rootPath = SaxParserUtil.removeRedundantParentAxis(rootPath)).equals("//") || rootPath.equals("//*")) {
            String[] temp = columnPath.split("\\Q/\\E");
            if (temp.length <= 2) {
                return null;
            }
            String result = EMPTY_STRING;
            int i = 2;
            while (i < temp.length) {
                result = String.valueOf(result) + FORWARD_SLASH + temp[i];
                ++i;
            }
            return result;
        }
        if (XPathPopulationUtil.isDescendantOrSelf(columnPath, rootPath)) {
            return columnPath.replaceFirst("\\Q" + rootPath + "\\E", EMPTY_STRING);
        }
        return XPathPopulationUtil.getXPathExpression(rootPath, columnPath);
    }

    private static boolean isDescendantOrSelf(String candidate, String target) {
        if (!candidate.startsWith(target)) {
            return false;
        }
        String[] candidateFgt = candidate.split(FORWARD_SLASH);
        String[] targetFgt = target.split(FORWARD_SLASH);
        int i = 0;
        while (i < targetFgt.length) {
            if (!targetFgt[i].equals(candidateFgt[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getXPathExpression(String rootPath, String columnPath) {
        String[] rootPathFrags = rootPath.replaceAll("\\Q[\\E\\d+\\Q]\\E", EMPTY_STRING).split(FORWARD_SLASH);
        String[] columnPathFrags = columnPath.replaceAll("\\Q[\\E\\d+\\Q]\\E", EMPTY_STRING).split(FORWARD_SLASH);
        if (rootPathFrags.length < 2 || columnPathFrags.length < 2) {
            return null;
        }
        int startingIndex = 0;
        int endingIndex = 0;
        if (!rootPath.startsWith("//")) {
            if (!XPathPopulationUtil.is2FragmentsEqual(columnPathFrags[1], rootPathFrags[1])) {
                return null;
            }
            rootPathFrags = (FORWARD_SLASH + rootPath).split(FORWARD_SLASH);
        }
        assert (rootPathFrags.length >= 3);
        String commonRoot = rootPathFrags[2];
        startingIndex = XPathPopulationUtil.getStartingIndex(columnPathFrags, commonRoot);
        if (columnPathFrags.length < startingIndex + 1 || startingIndex == 0) {
            return null;
        }
        endingIndex = XPathPopulationUtil.getEndingIndex(rootPathFrags, columnPathFrags, startingIndex);
        return XPathPopulationUtil.populateXpathExpression(columnPath, rootPathFrags, startingIndex, endingIndex);
    }

    private static int getStartingIndex(String[] columnPathFrags, String commonRoot) {
        int startingIndex = 0;
        int i = 1;
        while (i < columnPathFrags.length) {
            if (XPathPopulationUtil.is2FragmentsEqual(commonRoot, columnPathFrags[i])) {
                startingIndex = i;
                break;
            }
            ++i;
        }
        return startingIndex;
    }

    private static boolean is2FragmentsEqual(String frag1, String frag2) {
        if (frag1.equals(XPATH_WILDCARD) || frag2.equals(XPATH_WILDCARD)) {
            return true;
        }
        return frag1.equals(frag2);
    }

    private static int getEndingIndex(String[] rootPathFrags, String[] columnPathFrags, int startingIndex) {
        int start = startingIndex;
        int endingIndex = 0;
        int i = startingIndex + 1;
        while (i < columnPathFrags.length && i - startingIndex + 2 < rootPathFrags.length) {
            if (!XPathPopulationUtil.is2FragmentsEqual(columnPathFrags[i], rootPathFrags[i - startingIndex + 2])) {
                endingIndex = i - 1;
                break;
            }
            start = i++;
        }
        if (endingIndex == 0 && startingIndex != 0) {
            endingIndex = start;
        }
        return endingIndex;
    }

    private static String populateXpathExpression(String columnPath, String[] rootPathFrags, int startingIndex, int endingIndex) {
        String result = EMPTY_STRING;
        int fetchBackLevel = rootPathFrags.length - 3 - (endingIndex - startingIndex);
        int i = 0;
        while (i < fetchBackLevel) {
            result = String.valueOf(result) + "../";
            ++i;
        }
        return XPathPopulationUtil.addXPathFragsToAString(columnPath.replaceAll(XPATH_ATTR_HEADER_WITH_SQUARE_PATTERN, XPATH_ATTR_HEADER_WITH_SLASH).split(FORWARD_SLASH), endingIndex + 1, result);
    }
}

