/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect;

import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.OrderByResultColumn;
import org.eclipse.datatools.modelbase.sql.query.OrderBySpecification;
import org.eclipse.datatools.modelbase.sql.query.OrderByValueExpression;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.emf.common.util.EList;

public class OrderByTableElement {
    protected OrderBySpecification orderBy;
    protected QueryValueExpression columnExpr;
    protected QuerySelectStatement fullSelect;

    public OrderByTableElement(QuerySelectStatement target, OrderBySpecification ordrBy) {
        this.fullSelect = target;
        this.orderBy = ordrBy;
    }

    public QuerySelectStatement getFullSelectStatement() {
        return this.fullSelect;
    }

    public OrderBySpecification getOrderBy() {
        return this.orderBy;
    }

    public void modify(Object key, Object propValue) {
        if (key == SQLBuilderConstants.P_STATEMENT_COLUMN && propValue instanceof QueryValueExpression) {
            SelectHelper.appendOrderByColumn(this.fullSelect, (QueryValueExpression)propValue, this.getSortType());
        } else if (key == SQLBuilderConstants.P_STATEMENT_SORTTYPE) {
            this.updateSortType((String)propValue);
        } else if (key == SQLBuilderConstants.P_STATEMENT_SORTORDER) {
            this.updateSortOrder((String)propValue);
        }
        SelectHelper.refresh(this.fullSelect);
    }

    public String getColumnText(int columnIndex) {
        String colText = "";
        if (columnIndex == 0 && this.orderBy != null) {
            colText = this.getOrderBySQL();
        } else if (columnIndex == 1) {
            colText = this.getSortType();
        } else if (columnIndex == 2) {
            colText = this.getSortOrder();
        }
        return colText;
    }

    String getOrderBySQL() {
        String sql = "";
        if (this.orderBy instanceof OrderByValueExpression) {
            sql = ((OrderByValueExpression)this.orderBy).getValueExpr().getSQL();
        } else if (this.orderBy instanceof OrderByResultColumn) {
            sql = ((OrderByResultColumn)this.orderBy).getResultCol().getSQL();
        } else if (this.orderBy != null) {
            sql = this.orderBy.getSQL();
        }
        return sql;
    }

    private void updateSortType(String value) {
        if (this.orderBy != null && value != null) {
            if (value.equalsIgnoreCase(Messages._UI_COMBO_SORT_ASCENDING)) {
                this.orderBy.setDescending(false);
            } else if (value.equalsIgnoreCase(Messages._UI_COMBO_SORT_DESCENDING)) {
                this.orderBy.setDescending(true);
            }
        }
    }

    private void updateSortOrder(String value) {
        if (this.fullSelect != null && this.orderBy != null) {
            int position = Integer.parseInt(value) - 1;
            EList orderList = this.fullSelect.getOrderByClause();
            SelectHelper.moveOrderByToPosition(this.orderBy, (List)orderList, position);
        }
    }

    String getOrderByExpr() {
        String exprString = "";
        if (this.orderBy != null) {
            exprString = this.orderBy.getSQL();
        }
        return exprString;
    }

    String getSortType() {
        String result = "";
        if (this.orderBy != null) {
            boolean isDescending = this.orderBy.isDescending();
            result = isDescending ? Messages._UI_COMBO_SORT_DESCENDING : Messages._UI_COMBO_SORT_ASCENDING;
        }
        return result;
    }

    String getSortOrder() {
        EList orderList;
        int position;
        String sortOrder = "";
        if (this.fullSelect != null && this.orderBy != null && (position = (orderList = this.fullSelect.getOrderByClause()).indexOf(this.orderBy)) != -1) {
            sortOrder = new Integer(position + 1).toString();
        }
        return sortOrder;
    }
}

