/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.valueexpr;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.result.ColumnIdentifier;
import org.eclipse.datatools.connectivity.oda.spec.util.ValidatorUtil;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.AtomicValueExpression;

public class ColumnValueExpression
extends AtomicValueExpression {
    private ColumnIdentifier m_columnRef;

    public ColumnValueExpression(ColumnIdentifier columnRef) {
        if (columnRef == null) {
            throw new NullPointerException(Messages.bind((String)Messages.querySpec_NULL_CONSTRUCTOR_ARG, (Object)ColumnValueExpression.class.getName()));
        }
        if (!columnRef.isValid()) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.querySpec_ILLEGAL_CONSTRUCTOR_ARG, (Object)ColumnValueExpression.class.getName()));
        }
        this.m_columnRef = columnRef;
    }

    public String getName() {
        if (this.m_columnRef.hasNameExpression()) {
            return this.m_columnRef.getNameExpression();
        }
        return this.m_columnRef.getNumber().toString();
    }

    public ExpressionVariable.VariableType getVariableType() {
        return ExpressionVariable.VariableType.RESULT_SET_COLUMN;
    }

    public Integer getColumnNumber() {
        return this.getColumnReference().getNumber();
    }

    public String getColumnExpression() {
        return this.getColumnReference().getNameExpression();
    }

    public ColumnIdentifier getColumnReference() {
        return this.m_columnRef;
    }

    public void validateSyntax(ValidationContext context) throws OdaException {
        if (!this.getColumnReference().isValid()) {
            throw ValidatorUtil.newValueExprException(Messages.bind((String)Messages.querySpec_INVALID_COLUMN_IDENTIFIER, (Object)this.getColumnReference()), this);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(this.getName()) + " ");
        buffer.append(this.getColumnReference());
        return buffer.toString();
    }
}

