/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.impl.DataTypes;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingElement;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.DataTypeUtil;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class ColumnMappingTableViewer {
    private TableViewer viewer;
    private Composite mainControl;
    private Button btnAdd;
    private Button btnEdit;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private MenuItem itmRemove;
    private MenuItem itmRemoveAll;

    public ColumnMappingTableViewer(Composite parent, boolean showMenus, boolean showButtons, boolean enableKeyStrokes) {
        this.mainControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.mainControl.setLayout((Layout)layout);
        this.viewer = new TableViewer(this.mainControl, 68354);
        GridData data = new GridData(1808);
        this.mainControl.setLayoutData((Object)data);
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        if (showButtons) {
            Composite btnComposite = new Composite(this.mainControl, 0);
            data = new GridData();
            data.verticalAlignment = 0x1000000;
            btnComposite.setLayoutData((Object)data);
            GridLayout btnLayout = new GridLayout();
            layout.marginHeight = 0;
            btnLayout.marginWidth = 0;
            btnLayout.verticalSpacing = 10;
            btnComposite.setLayout((Layout)btnLayout);
            GridData btnData = new GridData();
            this.btnAdd = new Button(btnComposite, 0);
            this.btnAdd.setText(Messages.getString("menu.button.add"));
            this.btnAdd.setEnabled(true);
            this.btnAdd.setLayoutData((Object)btnData);
            btnData.widthHint = this.btnAdd.getSize().x > 60 ? this.btnAdd.getSize().x : 60;
            btnData = new GridData(2);
            this.btnEdit = new Button(btnComposite, 0);
            this.btnEdit.setText(Messages.getString("menu.button.edit"));
            this.btnEdit.setLayoutData((Object)btnData);
            this.btnEdit.setEnabled(false);
            btnData.widthHint = this.btnEdit.getSize().x > 60 ? this.btnEdit.getSize().x : 60;
            btnData = new GridData(2);
            this.btnRemove = new Button(btnComposite, 0);
            this.btnRemove.setText(Messages.getString("menu.button.remove"));
            this.btnRemove.setLayoutData((Object)btnData);
            this.btnRemove.setEnabled(false);
            btnData.widthHint = this.btnRemove.getSize().x > 60 ? this.btnRemove.getSize().x : 60;
            btnData = new GridData(2);
            this.btnUp = new Button(btnComposite, 0);
            this.btnUp.setText(Messages.getString("menu.button.up"));
            this.btnUp.setLayoutData((Object)btnData);
            this.btnUp.setEnabled(false);
            btnData.widthHint = this.btnUp.getSize().x > 60 ? this.btnUp.getSize().x : 60;
            btnData = new GridData(2);
            this.btnDown = new Button(btnComposite, 0);
            this.btnDown.setText(Messages.getString("menu.button.down"));
            this.btnDown.setLayoutData((Object)btnData);
            this.btnDown.setEnabled(false);
            btnData.widthHint = this.btnDown.getSize().x > 60 ? this.btnDown.getSize().x : 60;
            this.btnDown.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (showMenus) {
            Menu menu = new Menu((Control)this.viewer.getTable());
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    ColumnMappingTableViewer.this.viewer.cancelEditing();
                }
            });
            this.itmRemove = new MenuItem(menu, 0);
            this.itmRemove.setText(Messages.getString("menu.menuItem.remove"));
            this.itmRemoveAll = new MenuItem(menu, 0);
            this.itmRemoveAll.setText(Messages.getString("menu.menuItem.removeAll"));
            this.viewer.getTable().setMenu(menu);
        }
        if (enableKeyStrokes) {
            this.viewer.getTable().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    int cfr_ignored_0 = e.keyCode;
                }
            });
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public Composite getControl() {
        return this.mainControl;
    }

    public Button getAddButton() {
        return this.btnAdd;
    }

    public Button getUpButton() {
        return this.btnUp;
    }

    public Button getDownButton() {
        return this.btnDown;
    }

    public Button getRemoveButton() {
        return this.btnRemove;
    }

    public Button getEditButton() {
        return this.btnEdit;
    }

    public MenuItem getRemoveMenuItem() {
        return this.itmRemove;
    }

    public MenuItem getRemoveAllMenuItem() {
        return this.itmRemoveAll;
    }

    public List refresh(RelationInformation info, String tableName, Map columnMapping) {
        ArrayList<ColumnMappingElement> columnsList = new ArrayList<ColumnMappingElement>();
        if (info == null) {
            return columnsList;
        }
        String[] columnName = info.getTableColumnNames(tableName);
        String[] columnType = new String[columnName.length];
        String[] columnPath = new String[columnName.length];
        ColumnMappingElement element = null;
        int i = 0;
        while (i < columnName.length) {
            columnType[i] = info.getTableColumnType(tableName, columnName[i]);
            columnPath[i] = info.getTableOriginalColumnPath(tableName, columnName[i]);
            element = new ColumnMappingElement();
            element.setColumnName(columnName[i]);
            element.setXPath(columnPath[i]);
            try {
                element.setType(DataTypeUtil.getDataTypeDisplayName(DataTypes.getType((String)columnType[i])));
            }
            catch (OdaException odaException) {}
            columnMapping.put(columnName[i], element);
            columnsList.add(element);
            ++i;
        }
        return columnsList;
    }
}

