/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ElementNullability implements Enumerator
{
    UNKNOWN_LITERAL(0, "Unknown", "Unknown"),
    NULLABLE_LITERAL(1, "Nullable", "Nullable"),
    NOT_NULLABLE_LITERAL(2, "NotNullable", "NotNullable");

    public static final String copyright = "Copyright (c) 2005, 2009 Actuate Corporation";
    public static final int UNKNOWN = 0;
    public static final int NULLABLE = 1;
    public static final int NOT_NULLABLE = 2;
    private static final ElementNullability[] VALUES_ARRAY;
    public static final List<ElementNullability> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ElementNullability[]{UNKNOWN_LITERAL, NULLABLE_LITERAL, NOT_NULLABLE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ElementNullability get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ElementNullability result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ElementNullability getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ElementNullability result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ElementNullability get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN_LITERAL;
            }
            case 1: {
                return NULLABLE_LITERAL;
            }
            case 2: {
                return NOT_NULLABLE_LITERAL;
            }
        }
        return null;
    }

    private ElementNullability(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

