/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.basequery;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.BaseQuery;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.util.ValidatorUtil;

public class CombinedQuery
extends BaseQuery {
    private CombinedType m_combinedType;
    private QuerySpecification m_leftQuery;
    private QuerySpecification m_rightQuery;
    private CombinedQueryCondition m_combinedCondition;
    private static final CombinedQuery sm_factory = new CombinedQuery();

    public CombinedQuery() {
        this(CombinedType.INNER_JOIN);
    }

    public CombinedQuery(CombinedType combinedType) {
        this.m_combinedType = combinedType;
    }

    public void setCombinedQuery(QuerySpecification leftQuery, QuerySpecification rightQuery, CombinedQueryCondition combinedCondition) throws OdaException {
        this.m_leftQuery = leftQuery;
        this.m_rightQuery = rightQuery;
        this.m_combinedCondition = combinedCondition;
        this.validateSyntax(null);
    }

    public QuerySpecification getLeftQuery() {
        return this.m_leftQuery;
    }

    public QuerySpecification getRightQuery() {
        return this.m_rightQuery;
    }

    public CombinedType getCombinedType() {
        return this.m_combinedType;
    }

    public CombinedQueryCondition getCombinedCondition() {
        return this.m_combinedCondition;
    }

    @Override
    public void validateSyntax(ValidationContext context) throws OdaException {
        if (this.m_leftQuery == null || this.m_rightQuery == null || this.m_combinedCondition == null) {
            throw ValidatorUtil.newBaseQueryException(Messages.querySpec_INCOMPLETE_COMBINED_QUERY, this);
        }
        try {
            this.m_combinedCondition.validateSyntax(context);
        }
        catch (OdaException ex) {
            throw ValidatorUtil.newBaseQueryException(this, ex);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(CombinedQuery.class.getSimpleName());
        buffer.append(" ");
        buffer.append(this.m_combinedType.name());
        buffer.append("\n    { leftQuery: ");
        buffer.append(this.m_leftQuery);
        buffer.append(" }\n    { rightQuery: ");
        buffer.append(this.m_rightQuery);
        buffer.append(" }\n    { combinedQueryCondition: ");
        buffer.append(this.m_combinedCondition);
        buffer.append(" }");
        return buffer.toString();
    }

    public static CombinedQueryCondition createCombinedCondition(FilterExpression combinedExpr) {
        CombinedQuery combinedQuery = sm_factory;
        combinedQuery.getClass();
        return combinedQuery.new CombinedQueryCondition(combinedExpr);
    }

    public class CombinedQueryCondition {
        private FilterExpression m_expr;

        public CombinedQueryCondition(FilterExpression matchingExpr) {
            this.m_expr = matchingExpr;
        }

        public FilterExpression getMatchingExpression() {
            return this.m_expr;
        }

        public void validate() throws OdaException {
            this.validate(null);
        }

        public void validate(ValidationContext context) throws OdaException {
            this.validateSyntax(context);
            this.m_expr.validate(context);
        }

        public void validateSyntax(ValidationContext context) throws OdaException {
            if (this.m_expr == null) {
                throw new OdaException(Messages.querySpec_MISSING_COMBINED_MATCHING_EXPR);
            }
            this.m_expr.validateSyntax(context);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(" { matching expr: ");
            buffer.append(this.m_expr);
            buffer.append(" }");
            return buffer.toString();
        }
    }

    public static enum CombinedType {
        INNER_JOIN,
        LEFT_OUTER,
        RIGHT_OUTER,
        FULL_OUTER;

    }
}

