/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.enablement.oda.xml.impl.Connection;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.ExceptionHandler;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLInformationHolder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class ResultSetTableViewer {
    private Table viewer;
    private Composite mainControl;
    private String[][] resultSet;
    private TableColumn column;
    private final int MAX_ROW = 500;
    private Object ri;
    private static final String EMPTY_STRING = "";

    public ResultSetTableViewer(Composite parent, boolean showMenus, boolean showButtons, boolean enableKeyStrokes, Object resourceIdentifiers) {
        this.ri = resourceIdentifiers;
        this.mainControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.mainControl.setLayout((Layout)layout);
        GridData data = null;
        this.viewer = new Table(this.mainControl, 65536);
        data = new GridData();
        data.widthHint = 600;
        data.heightHint = 400;
        this.viewer.setLayoutData((Object)data);
        this.viewer.setHeaderVisible(true);
        this.viewer.setLinesVisible(true);
        this.retrieveResult();
    }

    private void retrieveResult() {
        BusyIndicator.showWhile((Display)this.viewer.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ResultSetTableViewer.this.refresh();
            }
        });
    }

    protected void refresh() {
        block18: {
            Connection conn = new Connection();
            IResultSet rs = null;
            Properties properties = new Properties();
            String xmlFile = XMLInformationHolder.getPropertyValue("XML_FILE");
            if (xmlFile == null || xmlFile.trim().length() == 0) {
                xmlFile = XMLInformationHolder.getPropertyValue("FILELIST");
            }
            properties.setProperty("FILELIST", xmlFile == null ? EMPTY_STRING : xmlFile);
            String xmlEncoding = XMLInformationHolder.getPropertyValue("ENCODINGLIST");
            properties.setProperty("ENCODINGLIST", xmlEncoding == null ? EMPTY_STRING : xmlEncoding);
            try {
                try {
                    conn.setAppContext((Object)DesignSessionUtil.createResourceIdentifiersContext((ResourceIdentifiers)((ResourceIdentifiers)this.ri)));
                    conn.open(properties);
                    IQuery query = conn.newQuery(null);
                    int maxRow = Integer.parseInt(XMLInformationHolder.getPropertyValue("MAX_ROW") != null ? XMLInformationHolder.getPropertyValue("MAX_ROW") : "-1");
                    query.setMaxRows(maxRow);
                    query.prepare(XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
                    rs = query.executeQuery();
                    this.refreshTable(rs);
                }
                catch (Exception ex) {
                    ExceptionHandler.showException(this.getControl().getShell(), Messages.getString("error.label"), ex.getMessage(), ex);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        break block18;
                    }
                    catch (OdaException odaException) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (OdaException odaException) {}
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (OdaException odaException) {}
        }
    }

    private void refreshTable(IResultSet rs) {
        this.viewer.removeAll();
        int i = 0;
        while (i < this.viewer.getColumnCount()) {
            this.viewer.getColumn(i).setText(EMPTY_STRING);
            ++i;
        }
        while (this.viewer.getColumnCount() > 0) {
            this.viewer.getColumn(0).dispose();
        }
        int count = 0;
        String[] columnName = null;
        int rowCount = 0;
        if (rs != null) {
            IResultSetMetaData metadata = null;
            try {
                metadata = rs.getMetaData();
                count = metadata.getColumnCount();
                this.resultSet = new String[500][count];
                columnName = new String[count];
                int[] columnType = new int[count];
                int i2 = 0;
                while (i2 < count) {
                    columnName[i2] = metadata.getColumnName(i2 + 1);
                    columnType[i2] = metadata.getColumnType(i2 + 1);
                    ++i2;
                }
                while (rs.next()) {
                    i2 = 0;
                    while (i2 < count && rowCount < 500) {
                        switch (columnType[i2]) {
                            case 12: {
                                this.resultSet[rowCount][i2] = rs.getString(i2 + 1);
                                break;
                            }
                            case 4: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getInt(i2 + 1));
                                break;
                            }
                            case 8: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getDouble(i2 + 1));
                                break;
                            }
                            case 91: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getDate(i2 + 1));
                                break;
                            }
                            case 92: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getTime(i2 + 1));
                                break;
                            }
                            case 93: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getTimestamp(i2 + 1));
                                break;
                            }
                            case 2: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getBigDecimal(i2 + 1));
                                break;
                            }
                            case 2004: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getBlob(i2 + 1));
                                break;
                            }
                            case 16: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getBoolean(i2 + 1));
                                break;
                            }
                            default: {
                                this.resultSet[rowCount][i2] = rs.getString(i2 + 1);
                            }
                        }
                        if (rs.wasNull()) {
                            this.resultSet[rowCount][i2] = null;
                        }
                        ++i2;
                    }
                    ++rowCount;
                }
                if (rowCount > 500) {
                    MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)Messages.getString("ColumnMappingDialog.prompt.dialog.title"), (String)Messages.getString("ColumnMappingDialog.prompt.maxRow"));
                    rowCount = 500;
                }
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
            this.column = new TableColumn(this.viewer, 16384);
            this.column.setText(" ");
            this.column.setResizable(false);
            this.column.setWidth(20);
            int i3 = 0;
            while (i3 < count) {
                this.column = this.viewer.getColumnCount() <= i3 + 1 ? new TableColumn(this.viewer, 16384) : this.viewer.getColumn(i3 + 1);
                this.column.setText(columnName[i3]);
                this.column.setWidth(100);
                this.addColumnSortListener(this.column, i3 + 1);
                ++i3;
            }
            i3 = 0;
            while (i3 < rowCount) {
                TableItem tableItem = new TableItem(this.viewer, 0);
                String[] record = new String[count + 1];
                int j = 0;
                while (j < count) {
                    record[j + 1] = this.resultSet[i3][j];
                    ++j;
                }
                tableItem.setText(record);
                this.viewer.redraw();
                ++i3;
            }
        }
    }

    private void addColumnSortListener(TableColumn column, final int index) {
        column.addSelectionListener(new SelectionListener(){
            private boolean asc = false;

            public void widgetSelected(SelectionEvent e) {
                ResultSetTableViewer.this.sort(index, this.asc);
                this.asc = !this.asc;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void sort(final int columnIndex, final boolean asc) {
        TableItem[] tableItems = this.viewer.getItems();
        Arrays.sort(tableItems, new Comparator(){

            public int compare(Object o1, Object o2) {
                TableItem it1 = (TableItem)o1;
                TableItem it2 = (TableItem)o2;
                int result = 0;
                result = asc ? it1.getText(columnIndex).compareTo(it2.getText(columnIndex)) : it2.getText(columnIndex).compareTo(it1.getText(columnIndex));
                return result;
            }
        });
        String[][] records = this.mapTableItemsTo2DArray(tableItems);
        this.viewer.removeAll();
        int i = 0;
        while (i < tableItems.length) {
            TableItem tableItem = new TableItem(this.viewer, 0);
            tableItem.setText(records[i]);
            ++i;
        }
    }

    private String[][] mapTableItemsTo2DArray(TableItem[] tableItems) {
        String[][] records = new String[tableItems.length][this.viewer.getColumnCount()];
        int i = 0;
        while (i < tableItems.length) {
            int j = 0;
            while (j < this.viewer.getColumnCount()) {
                records[i][j] = tableItems[i].getText(j);
                ++j;
            }
            ++i;
        }
        return records;
    }

    public Table getViewer() {
        return this.viewer;
    }

    public Composite getControl() {
        return this.mainControl;
    }
}

