/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.pde.ds.internal.annotations.Activator;
import org.eclipse.pde.ds.internal.annotations.AnnotationVisitor;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationProblem;
import org.eclipse.pde.ds.internal.annotations.Debug;
import org.eclipse.pde.ds.internal.annotations.ProjectContext;
import org.eclipse.pde.ds.internal.annotations.ProjectState;

public class AnnotationProcessor
extends ASTRequestor {
    private static final String DS_BUILDER = "org.eclipse.pde.ds.core.builder";
    static final Debug debug = Debug.getDebug("ds-annotation-builder/processor");
    private final ProjectContext context;
    private final Map<ICompilationUnit, BuildContext> fileMap;
    private boolean hasBuilder;

    public AnnotationProcessor(ProjectContext context, Map<ICompilationUnit, BuildContext> fileMap) {
        this.context = context;
        this.fileMap = fileMap;
    }

    static String getCompilationUnitKey(ICompilationUnit source) {
        IJavaElement parent = source.getParent();
        if (parent == null) {
            return source.getElementName();
        }
        return String.format("%s/%s", parent.getElementName().replace('.', '/'), source.getElementName());
    }

    public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
        String cuKey = AnnotationProcessor.getCompilationUnitKey(source);
        this.context.getUnprocessed().remove(cuKey);
        ProjectState state = this.context.getState();
        HashMap<String, String> dsKeys = new HashMap<String, String>();
        HashSet<DSAnnotationProblem> problems = new HashSet<DSAnnotationProblem>();
        ast.accept((ASTVisitor)new AnnotationVisitor(this, state, dsKeys, problems));
        Collection<String> oldDSKeys = state.updateMappings(cuKey, dsKeys);
        if (oldDSKeys != null) {
            oldDSKeys.removeAll(dsKeys.values());
            this.context.getAbandoned().addAll(oldDSKeys);
        }
        if (!problems.isEmpty()) {
            char[] filename = source.getResource().getFullPath().toString().toCharArray();
            for (DSAnnotationProblem problem : problems) {
                problem.setOriginatingFileName(filename);
                if (problem.getSourceStart() < 0) continue;
                problem.setSourceLineNumber(ast.getLineNumber(problem.getSourceStart()));
            }
            BuildContext buildContext = this.fileMap.get(source);
            if (buildContext != null) {
                buildContext.recordNewProblems(problems.toArray(new CategorizedProblem[problems.size()]));
            }
        }
    }

    private void ensureDSProject(IProject project) throws CoreException {
        ICommand[] commands;
        IProjectDescription description = project.getDescription();
        ICommand[] iCommandArray = commands = description.getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (DS_BUILDER.equals(command.getBuilderName())) {
                return;
            }
            ++n2;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = description.newCommand();
        command.setBuilderName(DS_BUILDER);
        newCommands[newCommands.length - 1] = command;
        description.setBuildSpec(newCommands);
        project.setDescription(description, null);
    }

    private void ensureExists(IFolder folder) throws CoreException {
        if (folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent != null && parent.getType() == 2) {
            this.ensureExists((IFolder)parent);
        }
        folder.create(true, true, null);
    }

    void verifyOutputLocation(IFile file) throws CoreException {
        if (this.hasBuilder) {
            return;
        }
        this.hasBuilder = true;
        IProject project = file.getProject();
        IPath parentPath = file.getParent().getProjectRelativePath();
        if (!parentPath.isEmpty()) {
            IFolder folder = project.getFolder(parentPath);
            this.ensureExists(folder);
        }
        try {
            this.ensureDSProject(project);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }
}

