/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.debug.ui.console.IConsoleLineTrackerExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class ConsoleLineNotifier
implements IPatternMatchListener,
IPropertyChangeListener {
    private List<IConsoleLineTracker> fListeners = new ArrayList<IConsoleLineTracker>(2);
    private ProcessConsole fConsole = null;

    public void connect(TextConsole console) {
        if (console instanceof ProcessConsole) {
            this.fConsole = (ProcessConsole)console;
            IConsoleLineTracker[] iConsoleLineTrackerArray = DebugUIPlugin.getDefault().getProcessConsoleManager().getLineTrackers(this.fConsole.getProcess());
            int n = iConsoleLineTrackerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConsoleLineTracker lineTracker = iConsoleLineTrackerArray[n2];
                lineTracker.init(this.fConsole);
                this.addConsoleListener(lineTracker);
                ++n2;
            }
            this.fConsole.addPropertyChangeListener(this);
        }
    }

    public synchronized void disconnect() {
        try {
            int lastLine;
            IDocument document = this.fConsole.getDocument();
            if (document != null && document.getLineDelimiter(lastLine = document.getNumberOfLines() - 1) == null) {
                IRegion lineInformation = document.getLineInformation(lastLine);
                this.lineAppended(lineInformation);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public synchronized void consoleClosed() {
        int size = this.fListeners.size();
        int i = 0;
        while (i < size) {
            IConsoleLineTracker tracker = this.fListeners.get(i);
            if (tracker instanceof IConsoleLineTrackerExtension) {
                ((IConsoleLineTrackerExtension)tracker).consoleClosed();
            }
            tracker.dispose();
            ++i;
        }
        this.fConsole = null;
        this.fListeners = null;
    }

    public void addConsoleListener(IConsoleLineTracker listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            IDocument document = this.fConsole.getDocument();
            int lineOfOffset = document.getLineOfOffset(event.getOffset());
            String delimiter = document.getLineDelimiter(lineOfOffset);
            int strip = delimiter == null ? 0 : delimiter.length();
            Region region = new Region(event.getOffset(), event.getLength() - strip);
            this.lineAppended((IRegion)region);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void lineAppended(IRegion region) {
        int size = this.fListeners.size();
        int i = 0;
        while (i < size) {
            IConsoleLineTracker tracker = this.fListeners.get(i);
            tracker.lineAppended(region);
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE)) {
            this.fConsole.removePropertyChangeListener(this);
            this.consoleClosed();
        }
    }

    public String getPattern() {
        return ".*\\r(\\n?)|.*\\n";
    }

    public int getCompilerFlags() {
        return 0;
    }

    public String getLineQualifier() {
        return "\\n|\\r";
    }
}

