/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.multiphases.launcher;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.exception.TransitionException;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.transposer.ExtendedTransposer;
import org.polarsys.capella.transition.system2subsystem.launcher.SubSystemLauncher;
import org.polarsys.capella.transition.system2subsystem.multiphases.MultiphasesContext;
import org.polarsys.capella.transition.system2subsystem.transposer.SubsystemRuleHandler;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;
import org.polarsys.kitalpha.transposer.TransposerCorePlugin;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.mappings.purposes.NonExistingPurposeException;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

class AbstractHeadlessMultiphasesLauncher
extends SubSystemLauncher {
    private final MultiphasesContext context;
    private final MultiphasesContext.Mapping mapping;

    public AbstractHeadlessMultiphasesLauncher(MultiphasesContext context_p, MultiphasesContext.Mapping mapping_p) {
        this.context = context_p;
        this.mapping = mapping_p;
    }

    protected final String getMapping() {
        return this.mapping.getMappingId();
    }

    public final void run(Collection<?> selection_p, boolean save, IProgressMonitor monitor_p) {
        this.context.setMapping(this.mapping);
        super.run(selection_p, save, monitor_p);
    }

    public final void launch(Collection<?> selection_p, String purpose_p, String mappingId_p, IProgressMonitor monitor_p) {
        try {
            try {
                this.initializeLogHandler();
                this._transposer = this.createTransposer(purpose_p, mappingId_p);
                this.context.put("TRANSPOSER_INSTANCE", this._transposer);
                this.context.put("TRANSPOSER_SELECTION", selection_p);
                this.context.put("TransposerAnalysisSources", new ArrayList());
                this.context.put("_R_H", this._transposer.getRulesHandler());
                this.context.put("TRANSPOSER_PURPOSE", purpose_p);
                this.context.put("COMMAND_NAME", this.getName());
                this.context.put("TRANSPOSER_MAPPING", mappingId_p);
                this.context.put("TransposerAnalysisSources", new ArrayList());
                this.initializeParameters();
                this.triggerActivities(selection_p, this.getWorkflow(), monitor_p);
            }
            catch (OperationCanceledException e) {
                this.processCancel();
                throw e;
            }
            catch (TransitionException e) {
                LogHelper.getInstance().error(e.getMessage(), Messages.Activity_Transition);
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                LogHelper.getInstance().error(e.getMessage(), Messages.Activity_Transition);
                e.printStackTrace();
                throw new TransitionException((Throwable)e);
            }
        }
        finally {
            this.dispose();
        }
    }

    protected final WorkflowActivityParameter buildInitializationActivities() {
        return new WorkflowActivityParameter();
    }

    protected ExtendedTransposer createTransposer(String purpose_p, String mappingId_p) {
        return new ExtendedTransposer(purpose_p, mappingId_p){

            public void initCadence() {
                this.cadenceLauncher = AbstractHeadlessMultiphasesLauncher.this._cadenceLauncher;
            }

            public void initRulesHandler(String purpose_p, String mappingId_p) {
                try {
                    this._rulesHandler = new SubsystemRuleHandler(purpose_p, mappingId_p);
                    this._rulesHandler.setContext((IContext)AbstractHeadlessMultiphasesLauncher.this.context);
                    this.initContext();
                }
                catch (NonExistingPurposeException e) {
                    TransposerCorePlugin.getDefault().logError("org.polarsys.kitalpha.transposer", e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    protected final WorkflowActivityParameter buildDiffMergeActivities() {
        return new WorkflowActivityParameter();
    }

    protected WorkflowActivityParameter buildFinalizationActivities() {
        return new WorkflowActivityParameter();
    }
}

