/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.diffmerge.defer.ui;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EMFDiffMergeDeferUIPlugin
extends AbstractUIPlugin {
    protected static final String ICON_PATH = "icons/full/";
    private static EMFDiffMergeDeferUIPlugin plugin;

    public static EMFDiffMergeDeferUIPlugin getDefault() {
        return plugin;
    }

    public String getFileExtension() {
        return "pending";
    }

    public Image getImage(ImageID id) {
        return this.getImageRegistry().get(id.name());
    }

    public ImageDescriptor getImageDescriptor(ImageID id) {
        return this.getImageRegistry().getDescriptor(id.name());
    }

    public String getPluginId() {
        return this.getBundle().getSymbolicName();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        ImageID[] imageIDArray = ImageID.values();
        int n = imageIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageID imageId = imageIDArray[n2];
            this.registerLocalIcon(imageId, reg);
            ++n2;
        }
    }

    protected ImageDescriptor registerLocalIcon(ImageID imageID, ImageRegistry reg) {
        ImageDescriptor result = null;
        String path = ICON_PATH + imageID.toImageFileName();
        try {
            result = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)this.getBundle().getEntry(path)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result != null) {
            reg.put(imageID.name(), result);
        }
        return result;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static enum ImageID {
        CHANGE_OBJ,
        CHANGESET_OBJ,
        BLANK,
        EXPORT_WIZ,
        REMOVE;

        private boolean isPNG;

        private ImageID() {
            this(true);
        }

        private ImageID(boolean isPNGImage) {
            this.isPNG = isPNGImage;
        }

        public String toImageFileName() {
            String ext = this.isPNG ? "png" : "gif";
            return String.valueOf(this.name().toLowerCase()) + '.' + ext;
        }
    }
}

