/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.price.design.service.priceListener;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.vp.price.design.service.priceSwitch.BottomUpComputePricePaSwitch;
import org.polarsys.capella.vp.price.price.PartPrice;

public class PriceChangePreCommitListener
implements ResourceSetListener {
    BottomUpComputePricePaSwitch bottomUpSwitch = new BottomUpComputePricePaSwitch();

    public NotificationFilter getFilter() {
        return new NotificationFilter.Custom(){

            public boolean matches(Notification notification) {
                int eventType = notification.getEventType();
                Object notifier = notification.getNotifier();
                if (!(notification.isTouch() || eventType != 4 && eventType != 3 && eventType != 5 && eventType != 6)) {
                    Object feature = notification.getFeature();
                    if (feature instanceof EReference) {
                        return ((EReference)feature).isContainment();
                    }
                } else if (!notification.isTouch() && eventType == 1 && notifier instanceof PartPrice) {
                    return true;
                }
                return false;
            }
        };
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        TransactionalEditingDomain domain = event.getEditingDomain();
        ArrayList<RecordingCommand> commands = new ArrayList<RecordingCommand>();
        for (final Notification next : event.getNotifications()) {
            final EObject notifier = (EObject)next.getNotifier();
            switch (next.getEventType()) {
                case 1: {
                    commands.add(new RecordingCommand(domain){

                        protected void doExecute() {
                            if (notifier instanceof PartPrice) {
                                AbstractType physicalComponent = ((Part)notifier.eContainer()).getAbstractType();
                                PriceChangePreCommitListener.this.bottomUpSwitch.doSwitch((EObject)physicalComponent);
                            }
                        }
                    });
                    break;
                }
                case 3: {
                    commands.add(new RecordingCommand(domain){

                        protected void doExecute() {
                            Object newValue = next.getNewValue();
                            PriceChangePreCommitListener.this.triggerComputation(newValue, notifier);
                        }
                    });
                    break;
                }
                case 5: {
                    commands.add(new RecordingCommand(domain){

                        protected void doExecute() {
                            List newValues = (List)next.getNewValue();
                            newValues.stream().forEach(newValue -> PriceChangePreCommitListener.this.triggerComputation(newValue, notifier));
                        }
                    });
                    break;
                }
                case 4: {
                    commands.add(new RecordingCommand(domain){

                        protected void doExecute() {
                            Object oldValue = next.getOldValue();
                            PriceChangePreCommitListener.this.triggerComputation(oldValue, notifier);
                        }
                    });
                    break;
                }
                case 6: {
                    commands.add(new RecordingCommand(domain){

                        protected void doExecute() {
                            List oldValues = (List)next.getOldValue();
                            oldValues.stream().forEach(oldValue -> PriceChangePreCommitListener.this.triggerComputation(oldValue, notifier));
                        }
                    });
                    break;
                }
            }
        }
        return commands.isEmpty() ? null : new CompoundCommand(commands);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public void triggerComputation(Object objectAffected, EObject notifier) {
        if (objectAffected instanceof PartDeploymentLink) {
            this.bottomUpSwitch.doSwitch((EObject)((Part)((PartDeploymentLink)objectAffected).getLocation()).getAbstractType());
        } else if (objectAffected instanceof PartPrice) {
            this.bottomUpSwitch.doSwitch((EObject)((Part)notifier).getAbstractType());
        } else {
            this.bottomUpSwitch.doSwitch(notifier);
        }
    }
}

