/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.mass.helpers;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.vp.mass.mass.Mass;

public class MassHelper {
    private static final int Mass = 2;

    public static final boolean isPhysicalSystem(EObject eObject) {
        return eObject instanceof PhysicalComponent && eObject.eContainer() instanceof PhysicalComponentPkg;
    }

    public EList<EObject> getRootMassObjects(EObject eO) {
        BasicEList list = new BasicEList();
        if (eO instanceof NamedElement) {
            PhysicalComponent pc = (PhysicalComponent)eO;
            Part part = (Part)pc.getAbstractTypedElements().get(0);
            list.add((Object)part);
        }
        return list;
    }

    public EList<EObject> getMassObjects(EObject eObject) {
        BasicEList resultat = new BasicEList();
        resultat.addAll(this.getMassObjects(eObject, 2));
        return resultat;
    }

    public EList<EObject> getMassObject(EObject eObject) {
        return this.getMassObjects(eObject, 2);
    }

    private EObject getCorrectContainer(EObject container) {
        PhysicalComponent pc;
        if (!(container instanceof Part || container instanceof PhysicalComponent || container instanceof PhysicalComponentPkg)) {
            return null;
        }
        if (container instanceof PhysicalComponentPkg) {
            PhysicalComponentPkg pkg = (PhysicalComponentPkg)container;
            return (EObject)pkg.getOwnedParts().get(0);
        }
        if (container instanceof PhysicalComponent && !(pc = (PhysicalComponent)container).getAbstractTypedElements().isEmpty()) {
            return (EObject)pc.getAbstractTypedElements().get(0);
        }
        return container;
    }

    private EList<EObject> getMassObjects(EObject eObject, int kind) {
        EObject obj = this.getCorrectContainer(eObject);
        if (obj == null) {
            return ECollections.EMPTY_ELIST;
        }
        BasicEList resulat = new BasicEList();
        for (EObject i : obj.eContents()) {
            if (kind != 2 || !(i instanceof Mass)) continue;
            resulat.add((Object)i);
        }
        return resulat;
    }
}

