/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters071.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.0", "output_model_version=0.7.1", "service.ranking:Integer=100"}, service={IConverter.class})
public class RootElementConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootElementConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.7.0 to 0.7.1 : Executing Root Element Converter for model file : {}", (Object)targetFile.getName());
        Document document = filename2documentMap.get(targetFile);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        String rootTagName = rootElement.getName();
        if (!rootTagName.equals("Amalthea") && (rootTagName.equals("SWModel") || rootTagName.equals("HWModel") || rootTagName.equals("OSModel") || rootTagName.equals("StimuliModel") || rootTagName.equals("ConstraintsModel") || rootTagName.equals("EventModel") || rootTagName.equals("PropertyConstraintsModel") || rootTagName.equals("MappingModel") || rootTagName.equals("ConfigModel") || rootTagName.equals("ComponentsModel"))) {
            Element newRootElement = new Element("Amalthea");
            HelperUtil.copyAllNameSpaces((Element)rootElement, (Element)newRootElement);
            this.updateCurrentRootTagProps(rootElement);
            document.removeContent();
            newRootElement.addContent((Content)rootElement);
            document.addContent((Content)newRootElement);
        }
    }

    private void updateCurrentRootTagProps(Element rootElement) {
        HelperUtil.removeDefaultAttribs((Element)rootElement);
        String name = rootElement.getName();
        if (name.equals("SWModel")) {
            rootElement.setName("swModel");
        } else if (name.equals("HWModel")) {
            rootElement.setName("hwModel");
        } else if (name.equals("OSModel")) {
            rootElement.setName("osModel");
        } else if (name.equals("StimuliModel")) {
            rootElement.setName("stimuliModel");
        } else if (name.equals("ConstraintsModel")) {
            rootElement.setName("constraintsModel");
        } else if (name.equals("EventModel")) {
            rootElement.setName("eventModel");
        } else if (name.equals("PropertyConstraintsModel")) {
            rootElement.setName("propertyConstraintsModel");
        } else if (name.equals("MappingModel")) {
            rootElement.setName("mappingModel");
        } else if (name.equals("ConfigModel")) {
            rootElement.setName("configModel");
        } else if (name.equals("ComponentsModel")) {
            rootElement.setName("componentsModel");
        }
    }
}

