/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.util;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphSwitch;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public final class GraphIdentifierGenerator {
    private ElkNode graph;
    private boolean validate = false;
    private boolean generate = false;
    private boolean unique = false;
    private Random random = null;
    private int[] currentIDs = new int[ElementType.values().length];
    private Set<String> existingIdentifiers = new HashSet<String>();

    public static GraphIdentifierGenerator forGraph(ElkNode graph) {
        return new GraphIdentifierGenerator(graph);
    }

    public GraphIdentifierGenerator assertValid() {
        this.validate = true;
        return this;
    }

    public GraphIdentifierGenerator assertExists() {
        this.generate = true;
        return this;
    }

    public GraphIdentifierGenerator assertUnique() {
        this.unique = true;
        return this;
    }

    public void execute() {
        if (this.validate) {
            this.validateIdentifiers(this.graph);
        }
        if (this.generate) {
            this.generateIdentifiers(this.graph);
        }
        if (this.unique) {
            this.assertAllIdsUnique(this.graph);
        }
    }

    private GraphIdentifierGenerator(ElkNode graph) {
        this.graph = graph;
        TreeIterator iterator = graph.eAllContents();
        while (iterator.hasNext()) {
            ElkEdgeSection section;
            EObject currentEObject = (EObject)iterator.next();
            if (currentEObject instanceof ElkGraphElement) {
                ElkGraphElement element = (ElkGraphElement)currentEObject;
                if (element.getIdentifier() == null || element.getIdentifier().trim().isEmpty()) continue;
                this.existingIdentifiers.add(element.getIdentifier());
                continue;
            }
            if (!(currentEObject instanceof ElkEdgeSection) || (section = (ElkEdgeSection)currentEObject).getIdentifier() == null || section.getIdentifier().trim().isEmpty()) continue;
            this.existingIdentifiers.add(section.getIdentifier());
        }
    }

    private void validateIdentifiers(EObject element) {
        new ElkGraphSwitch<Boolean>(){

            @Override
            public Boolean caseElkNode(ElkNode node) {
                GraphIdentifierGenerator.this.validateIdentifier(node);
                node.getLabels().stream().forEach(l -> GraphIdentifierGenerator.this.validateIdentifiers((EObject)l));
                node.getPorts().stream().forEach(p -> GraphIdentifierGenerator.this.validateIdentifiers((EObject)p));
                node.getContainedEdges().stream().forEach(e -> GraphIdentifierGenerator.this.validateIdentifiers((EObject)e));
                node.getChildren().stream().forEach(c -> GraphIdentifierGenerator.this.validateIdentifiers((EObject)c));
                return true;
            }

            @Override
            public Boolean caseElkPort(ElkPort port) {
                GraphIdentifierGenerator.this.validateIdentifier(port);
                port.getLabels().stream().forEach(l -> GraphIdentifierGenerator.this.validateIdentifiers((EObject)l));
                return true;
            }

            @Override
            public Boolean caseElkLabel(ElkLabel label) {
                GraphIdentifierGenerator.this.validateIdentifier(label);
                label.getLabels().stream().forEach(l -> GraphIdentifierGenerator.this.validateIdentifiers((EObject)l));
                return true;
            }

            @Override
            public Boolean caseElkEdge(ElkEdge edge) {
                GraphIdentifierGenerator.this.validateIdentifier(edge);
                edge.getLabels().stream().forEach(l -> GraphIdentifierGenerator.this.validateIdentifiers((EObject)l));
                edge.getSections().stream().forEach(s -> GraphIdentifierGenerator.this.validateIdentifiers((EObject)s));
                return true;
            }

            @Override
            public Boolean caseElkEdgeSection(ElkEdgeSection section) {
                GraphIdentifierGenerator.this.validateIdentifier(section);
                return true;
            }
        }.doSwitch(element);
    }

    private void validateIdentifier(ElkGraphElement element) {
        String validIdentifier = this.validateIdentifier(element.getIdentifier());
        if (validIdentifier != null) {
            element.setIdentifier(validIdentifier);
        }
    }

    private void validateIdentifier(ElkEdgeSection section) {
        String validIdentifier = this.validateIdentifier(section.getIdentifier());
        if (validIdentifier != null) {
            section.setIdentifier(validIdentifier);
        }
    }

    private String validateIdentifier(String identifier) {
        if (Strings.isNullOrEmpty((String)identifier)) {
            return null;
        }
        boolean valid = true;
        char[] chars = identifier.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!(chars[i] >= 'A' && chars[i] <= 'Z' || chars[i] >= 'a' && chars[i] <= 'z' || chars[i] == '_' || i > 0 && chars[i] >= '0' && chars[i] <= '9')) {
                chars[i] = 95;
                valid = false;
            }
            ++i;
        }
        return valid ? null : new String(chars);
    }

    private GraphIdentifierGenerator generateIdentifiers(EObject element) {
        new ElkGraphSwitch<Boolean>(){

            @Override
            public Boolean caseElkNode(ElkNode node) {
                if (node.getParent() == null) {
                    if (node.getIdentifier() == null || node.getIdentifier().trim().isEmpty()) {
                        node.setIdentifier("G1");
                    }
                } else {
                    GraphIdentifierGenerator.this.setIdentifierIfMissing(node, ElementType.NODE);
                }
                node.getLabels().stream().forEach(l -> {
                    GraphIdentifierGenerator graphIdentifierGenerator = GraphIdentifierGenerator.this.generateIdentifiers((EObject)l);
                });
                node.getPorts().stream().forEach(p -> {
                    GraphIdentifierGenerator graphIdentifierGenerator = GraphIdentifierGenerator.this.generateIdentifiers((EObject)p);
                });
                node.getContainedEdges().stream().forEach(e -> {
                    GraphIdentifierGenerator graphIdentifierGenerator = GraphIdentifierGenerator.this.generateIdentifiers((EObject)e);
                });
                node.getChildren().stream().forEach(c -> {
                    GraphIdentifierGenerator graphIdentifierGenerator = GraphIdentifierGenerator.this.generateIdentifiers((EObject)c);
                });
                return true;
            }

            @Override
            public Boolean caseElkPort(ElkPort port) {
                GraphIdentifierGenerator.this.setIdentifierIfMissing(port, ElementType.PORT);
                port.getLabels().stream().forEach(l -> {
                    GraphIdentifierGenerator graphIdentifierGenerator = GraphIdentifierGenerator.this.generateIdentifiers((EObject)l);
                });
                return true;
            }

            @Override
            public Boolean caseElkLabel(ElkLabel label) {
                GraphIdentifierGenerator.this.setIdentifierIfMissing(label, ElementType.LABEL);
                label.getLabels().stream().forEach(l -> {
                    GraphIdentifierGenerator graphIdentifierGenerator = GraphIdentifierGenerator.this.generateIdentifiers((EObject)l);
                });
                return true;
            }

            @Override
            public Boolean caseElkEdge(ElkEdge edge) {
                GraphIdentifierGenerator.this.setIdentifierIfMissing(edge, ElementType.EDGE);
                edge.getLabels().stream().forEach(l -> {
                    GraphIdentifierGenerator graphIdentifierGenerator = GraphIdentifierGenerator.this.generateIdentifiers((EObject)l);
                });
                edge.getSections().stream().forEach(s -> {
                    GraphIdentifierGenerator graphIdentifierGenerator = GraphIdentifierGenerator.this.generateIdentifiers((EObject)s);
                });
                return true;
            }

            @Override
            public Boolean caseElkEdgeSection(ElkEdgeSection section) {
                GraphIdentifierGenerator.this.setIdentifierIfMissing(section);
                return true;
            }
        }.doSwitch(element);
        return this;
    }

    private void setIdentifierIfMissing(ElkGraphElement element, ElementType elementType) {
        if (element.getIdentifier() == null || element.getIdentifier().trim().isEmpty()) {
            String id = this.nextIdentifier(elementType);
            element.setIdentifier(id);
        }
    }

    private void setIdentifierIfMissing(ElkEdgeSection section) {
        if (section.getIdentifier() == null || section.getIdentifier().trim().isEmpty()) {
            String id = this.nextIdentifier(ElementType.EDGE_SECTION);
            section.setIdentifier(id);
        }
    }

    private String nextIdentifier(ElementType elementType) {
        int n;
        String identifier;
        do {
            n = elementType.ordinal();
        } while (this.existingIdentifiers.contains(identifier = elementType.elementPrefix + (this.currentIDs[n] = this.currentIDs[n] + 1)));
        return identifier;
    }

    private GraphIdentifierGenerator assertAllIdsUnique(EObject element) {
        HashSet knownIds = Sets.newHashSet();
        UnmodifiableIterator elementIt = Iterators.filter((Iterator)element.eAllContents(), ElkGraphElement.class);
        while (elementIt.hasNext()) {
            ElkGraphElement e = (ElkGraphElement)elementIt.next();
            while (knownIds.contains(e.getIdentifier())) {
                String newId = e.getIdentifier() + "_g" + this.fourDigitPaddedRandomNumber();
                e.setIdentifier(newId);
            }
            knownIds.add(e.getIdentifier());
        }
        return this;
    }

    private String fourDigitPaddedRandomNumber() {
        if (this.random == null) {
            this.random = new Random();
        }
        int rand = this.random.nextInt(10000);
        return this.padZeroes(Integer.toString(rand), 4);
    }

    private String padZeroes(String s, int length) {
        if (s.length() == length) {
            return s;
        }
        StringBuffer r = new StringBuffer(length);
        int i = 0;
        while (i < length - s.length()) {
            r.append("0");
            ++i;
        }
        r.append(s);
        return r.toString();
    }

    private static enum ElementType {
        NODE("N"),
        PORT("P"),
        EDGE("E"),
        EDGE_SECTION("ES"),
        LABEL("L");

        private String elementPrefix;

        private ElementType(String prefix) {
            this.elementPrefix = prefix;
        }
    }
}

