/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class DeleteNodesRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=498");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=500");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=499");
    private final RequestHeader requestHeader;
    private final DeleteNodesItem[] nodesToDelete;

    public DeleteNodesRequest(RequestHeader requestHeader, DeleteNodesItem[] nodesToDelete) {
        this.requestHeader = requestHeader;
        this.nodesToDelete = nodesToDelete;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public DeleteNodesItem[] getNodesToDelete() {
        return this.nodesToDelete;
    }

    protected DeleteNodesRequest(DeleteNodesRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((DeleteNodesRequestBuilder)b).requestHeader;
        this.nodesToDelete = ((DeleteNodesRequestBuilder)b).nodesToDelete;
    }

    public static DeleteNodesRequestBuilder<?, ?> builder() {
        return new DeleteNodesRequestBuilderImpl();
    }

    public DeleteNodesRequestBuilder<?, ?> toBuilder() {
        return new DeleteNodesRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteNodesRequest)) {
            return false;
        }
        DeleteNodesRequest other = (DeleteNodesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getNodesToDelete(), other.getNodesToDelete());
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteNodesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodesToDelete());
        return result;
    }

    @Override
    public String toString() {
        return "DeleteNodesRequest(requestHeader=" + this.getRequestHeader() + ", nodesToDelete=" + Arrays.deepToString(this.getNodesToDelete()) + ")";
    }

    private static final class DeleteNodesRequestBuilderImpl
    extends DeleteNodesRequestBuilder<DeleteNodesRequest, DeleteNodesRequestBuilderImpl> {
        private DeleteNodesRequestBuilderImpl() {
        }

        @Override
        protected DeleteNodesRequestBuilderImpl self() {
            return this;
        }

        @Override
        public DeleteNodesRequest build() {
            return new DeleteNodesRequest(this);
        }
    }

    public static abstract class DeleteNodesRequestBuilder<C extends DeleteNodesRequest, B extends DeleteNodesRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private DeleteNodesItem[] nodesToDelete;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DeleteNodesRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DeleteNodesRequest instance, DeleteNodesRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.nodesToDelete(instance.nodesToDelete);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B nodesToDelete(DeleteNodesItem[] nodesToDelete) {
            this.nodesToDelete = nodesToDelete;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DeleteNodesRequest.DeleteNodesRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", nodesToDelete=" + Arrays.deepToString(this.nodesToDelete) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DeleteNodesRequest> {
        @Override
        public Class<DeleteNodesRequest> getType() {
            return DeleteNodesRequest.class;
        }

        @Override
        public DeleteNodesRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            DeleteNodesItem[] nodesToDelete = (DeleteNodesItem[])decoder.readStructArray("NodesToDelete", DeleteNodesItem.TYPE_ID);
            return new DeleteNodesRequest(requestHeader, nodesToDelete);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DeleteNodesRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStructArray("NodesToDelete", (Object[])value.getNodesToDelete(), DeleteNodesItem.TYPE_ID);
        }
    }
}

