/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Level;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Node;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.AbstractChangeHierarchyOperation;

public class DeleteNodeOperation
extends AbstractChangeHierarchyOperation {
    private final Node node;
    private EObject parent;
    private int index;

    public DeleteNodeOperation(Node node) {
        super("Delete Node");
        this.node = node;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.parent = this.node.eContainer();
        this.index = this.getParentIndex();
        this.removeFromParent();
        DeleteNodeOperation.saveHierarchy(this.parent, monitor);
        return Status.OK_STATUS;
    }

    private int getParentIndex() {
        EList<? extends Node> parentContainer = this.getParentContainer();
        if (parentContainer != null) {
            return parentContainer.indexOf((Object)this.node);
        }
        return -1;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.removeFromParent();
        DeleteNodeOperation.saveHierarchy(this.parent, monitor);
        return Status.OK_STATUS;
    }

    private void removeFromParent() {
        EList<? extends Node> parentContainer = this.getParentContainer();
        if (parentContainer != null && this.index != -1) {
            parentContainer.remove(this.index);
        }
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject eObject;
        EObject eObject2 = this.parent;
        if (eObject2 instanceof RootLevel) {
            RootLevel root = (RootLevel)eObject2;
            root.getLevels().add(this.index, (Object)((Level)this.node));
        }
        if ((eObject = this.parent) instanceof Level) {
            Level level = (Level)eObject;
            level.getChildren().add(this.index, (Object)this.node);
        }
        DeleteNodeOperation.saveHierarchy(this.parent, monitor);
        return Status.OK_STATUS;
    }

    private EList<? extends Node> getParentContainer() {
        EObject eObject = this.parent;
        if (eObject instanceof RootLevel) {
            RootLevel root = (RootLevel)eObject;
            return root.getLevels();
        }
        EObject eObject2 = this.parent;
        if (eObject2 instanceof Level) {
            Level level = (Level)eObject2;
            return level.getChildren();
        }
        return null;
    }
}

