/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.view.editparts;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugTarget;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugThread;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.debug.EvaluatorProcess;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.AbstractDebugInterfaceValueEditPart;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.EventValueEditPart;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.EventValueEntity;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.InnerValueEditPart;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.InnerValueEntity;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.InterfaceValueEditPart;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.InterfaceValueEntity;
import org.eclipse.fordiac.ide.debug.ui.view.figure.FBDebugViewFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.FBTypeEditPart;
import org.eclipse.fordiac.ide.gef.policies.EmptyXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorMonitor;
import org.eclipse.fordiac.ide.model.eval.EvaluatorThreadPoolExecutor;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorCountingEventQueue;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorEventQueue;
import org.eclipse.fordiac.ide.model.eval.fb.SamplingFBEvaluator;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.swt.widgets.Display;

public class FBDebugViewRootEditPart
extends AbstractGraphicalEditPart {
    private static final long MIN_UPDATE_INTERVAL = 100L;
    private final Map<Variable<?>, InterfaceValueEntity> interfaceValues = new HashMap();
    private final Map<Event, EventValueEntity> eventValues = new HashMap<Event, EventValueEntity>();
    private long lastUpdate;
    private final EvaluatorMonitor evalMonitor = new EvaluatorMonitor.NullEvaluatorMonitor(){

        public void update(Collection<? extends Variable<?>> variables, Evaluator evaluator) {
            if (evaluator == FBDebugViewRootEditPart.this.getFBEvaluator()) {
                this.updateValues(variables);
            }
        }

        public void terminated(EvaluatorThreadPoolExecutor executor) {
            FBDebugViewRootEditPart.this.updateAllValues();
        }

        private void updateValues(Collection<? extends Variable<?>> variables) {
            Map editPartRegistry = FBDebugViewRootEditPart.this.getViewer().getEditPartRegistry();
            if (this.shouldUpdate()) {
                Display.getDefault().asyncExec(() -> {
                    variables.forEach(variable -> FBDebugViewRootEditPart.this.updateVariable(editPartRegistry, (Variable<?>)variable));
                    FBDebugViewRootEditPart.this.updateAllEvents(editPartRegistry);
                });
            }
        }

        private boolean shouldUpdate() {
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - FBDebugViewRootEditPart.this.lastUpdate;
            if (delta > 100L) {
                FBDebugViewRootEditPart.this.lastUpdate = currentTime;
                return true;
            }
            return false;
        }
    };
    private final IDebugEventSetListener debugEventListener = events -> {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent ev = debugEventArray[n2];
            switch (ev.getKind()) {
                case 2: {
                    if (!this.isCorrectSource(ev.getSource())) break;
                    this.updateAllValues();
                    break;
                }
                case 16: {
                    Object object = ev.getSource();
                    if (!(object instanceof EvaluatorDebugVariable)) break;
                    EvaluatorDebugVariable edVar = (EvaluatorDebugVariable)object;
                    Map editPartRegistry = this.getViewer().getEditPartRegistry();
                    Display.getDefault().asyncExec(() -> this.updateVariable(editPartRegistry, edVar.getInternalVariable()));
                    break;
                }
            }
            ++n2;
        }
    };

    public FBDebugViewFigure getFigure() {
        return (FBDebugViewFigure)super.getFigure();
    }

    protected IFigure createFigure() {
        FBDebugViewFigure newFigure = new FBDebugViewFigure(this.getNumWithedEventInputs(), this.getNumWithedEventOutputs());
        newFigure.setBorder((Border)new MarginBorder(10));
        newFigure.setOpaque(false);
        return newFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EmptyXYLayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof AbstractDebugInterfaceValueEditPart) {
                    return new ModifiedNonResizeableEditPolicy(3, new Insets(1));
                }
                return null;
            }
        });
    }

    public EvaluatorProcess getModel() {
        return (EvaluatorProcess)super.getModel();
    }

    public void activate() {
        super.activate();
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.getFigure(), (Object)new Rectangle(0, 0, -1, -1));
        this.getModel().getExecutor().addMonitor(this.evalMonitor);
        DebugPlugin.getDefault().addDebugEventListener(this.debugEventListener);
        this.lastUpdate = System.currentTimeMillis();
    }

    public void deactivate() {
        super.deactivate();
        this.getModel().getExecutor().removeMonitor(this.evalMonitor);
        DebugPlugin.getDefault().removeDebugEventListener(this.debugEventListener);
    }

    public FBEvaluator<?> getFBEvaluator() {
        return (FBEvaluator)this.getModel().getEvaluator();
    }

    private FBType getFBType() {
        return this.getFBEvaluator().getType();
    }

    protected List<?> getModelChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(this.getFBType());
        children.addAll(this.getEventValues());
        children.addAll(this.getInterfaceValues());
        return children;
    }

    private Collection<EventValueEntity> getEventValues() {
        if (this.eventValues.isEmpty()) {
            this.fillEventValues();
        }
        return this.eventValues.values();
    }

    private void fillEventValues() {
        FBEvaluatorEventQueue eventQueue = this.getFBEvaluator().getEventQueue();
        if (eventQueue instanceof FBEvaluatorCountingEventQueue) {
            FBEvaluatorCountingEventQueue countingEventQueue = (FBEvaluatorCountingEventQueue)eventQueue;
            this.getFBType().getInterfaceList().getEventInputs().forEach(ev -> {
                EventValueEntity eventValueEntity = this.addEventEntry(countingEventQueue, (Event)ev);
            });
            this.getFBType().getInterfaceList().getEventOutputs().forEach(ev -> {
                EventValueEntity eventValueEntity = this.addEventEntry(countingEventQueue, (Event)ev);
            });
        }
    }

    private EventValueEntity addEventEntry(FBEvaluatorCountingEventQueue queue, Event ev) {
        return this.eventValues.put(ev, new EventValueEntity(ev, queue.getCount(ev)));
    }

    private Collection<InterfaceValueEntity> getInterfaceValues() {
        if (this.interfaceValues.isEmpty()) {
            this.fillInterfaceValues();
        }
        return this.interfaceValues.values();
    }

    private void fillInterfaceValues() {
        EvaluatorDebugTarget debugTarget = (EvaluatorDebugTarget)this.getModel().getAdapter(IDebugTarget.class);
        this.getFBEvaluator().getContext().getMembers().entrySet().forEach(entry -> {
            IInterfaceElement interfaceElement = this.getFBType().getInterfaceList().getInterfaceElement((String)entry.getKey());
            if (interfaceElement != null) {
                this.interfaceValues.put((Variable)entry.getValue(), new InterfaceValueEntity(interfaceElement, (Variable)entry.getValue(), debugTarget));
            }
        });
        FBEvaluator<?> fBEvaluator = this.getFBEvaluator();
        if (fBEvaluator instanceof SamplingFBEvaluator) {
            SamplingFBEvaluator samplingEvaluator = (SamplingFBEvaluator)fBEvaluator;
            samplingEvaluator.getDelegate().getContext().getMembers().entrySet().forEach(entry -> {
                IInterfaceElement interfaceElement = this.getFBType().getInterfaceList().getInterfaceElement((String)entry.getKey());
                if (interfaceElement != null) {
                    this.interfaceValues.put((Variable)entry.getValue(), new InnerValueEntity(interfaceElement, (Variable)entry.getValue(), debugTarget));
                }
            });
        }
    }

    private void updateVariable(Map<Object, EditPart> editPartRegistry, Variable<?> variable) {
        EditPart ep;
        InterfaceValueEntity interfaceValueEntity = this.interfaceValues.get(variable);
        if (interfaceValueEntity != null && (ep = editPartRegistry.get(interfaceValueEntity)) instanceof InterfaceValueEditPart) {
            InterfaceValueEditPart ivEP = (InterfaceValueEditPart)ep;
            ivEP.updateValue();
            this.refreshVisuals();
        }
    }

    private void updateAllValues() {
        Map editPartRegistry = this.getViewer().getEditPartRegistry();
        Display.getDefault().asyncExec(() -> {
            this.interfaceValues.entrySet().forEach(entry -> this.updateVariable(editPartRegistry, (Variable)entry.getKey()));
            this.updateAllEvents(editPartRegistry);
        });
    }

    private void updateAllEvents(Map<Object, EditPart> editPartRegistry) {
        this.eventValues.entrySet().stream().map(entry -> (EditPart)editPartRegistry.get(entry.getValue())).filter(EventValueEditPart.class::isInstance).map(EventValueEditPart.class::cast).forEach(EventValueEditPart::update);
    }

    private boolean isCorrectSource(Object source) {
        EvaluatorDebugThread eDT;
        return source instanceof EvaluatorDebugThread && (eDT = (EvaluatorDebugThread)source).getDebugTarget().getProcess() == this.getModel();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure targetFigure = this.getTargetFigure(childEditPart);
        if (targetFigure != null) {
            targetFigure.add(((GraphicalEditPart)childEditPart).getFigure());
        } else {
            super.addChildVisual(childEditPart, index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure targetFigure = this.getTargetFigure(childEditPart);
        if (targetFigure != null) {
            targetFigure.remove(((GraphicalEditPart)childEditPart).getFigure());
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    private IFigure getTargetFigure(EditPart childEditPart) {
        EditPart editPart = childEditPart;
        Objects.requireNonNull(editPart);
        EditPart editPart2 = editPart;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FBTypeEditPart.class, InnerValueEditPart.class, AbstractDebugInterfaceValueEditPart.class}, (Object)editPart2, n)) {
            case 0 -> {
                FBTypeEditPart fbtEP = (FBTypeEditPart)editPart2;
                yield this.getFigure().getFBFigureContainer();
            }
            case 1 -> {
                InnerValueEditPart innerEP = (InnerValueEditPart)editPart2;
                if (innerEP.isInput()) {
                    yield this.getFigure().getInnerInputValues();
                }
                yield this.getFigure().getInnerOutputValues();
            }
            case 2 -> {
                AbstractDebugInterfaceValueEditPart ivEP = (AbstractDebugInterfaceValueEditPart)editPart2;
                if (ivEP.isInput()) {
                    yield this.getFigure().getOuterInputValues();
                }
                yield this.getFigure().getOuterOutputValues();
            }
            default -> null;
        };
    }

    private int getNumWithedEventInputs() {
        return (int)this.getFBType().getInterfaceList().getEventInputs().stream().filter(ev -> !ev.getWith().isEmpty()).count();
    }

    private int getNumWithedEventOutputs() {
        return (int)this.getFBType().getInterfaceList().getEventOutputs().stream().filter(ev -> !ev.getWith().isEmpty()).count();
    }
}

