<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_dav - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_dav</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_dav.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_dav.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_dav.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_dav.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Fonctionnalit de cration et gestion de versions de
documents via le web (<a href="http://www.webdav.org/">WebDAV</a>)</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>dav_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_dav.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module ajoute  Apache une fonctionnalit <a href="http://www.webdav.org">WebDAV</a> de classes 1 et 2
    ('Web-based Distributed Authoring and Versioning' ou Cration et
    gestion de versions de documents via le web). Il s'agit d'une
    extension du protocole HTTP qui permet de crer, dplacer, copier et
    supprimer des ressources ou collections de ressources sur un serveur
    web distant.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#dav">Dav</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#davdepthinfinity">DavDepthInfinity</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#davmintimeout">DavMinTimeout</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#example">Activation de WebDAV</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#security">Problmes concernant la scurit</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#complex">Configurations complexes</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="directive"><a href="../mod/mod_dav_fs.html#davlockdb">DavLockDB</a></code></li>
<li><code class="directive"><a href="../mod/core.html#limitxmlrequestbody">LimitXMLRequestBody</a></code></li>
<li><a href="http://www.webdav.org">Ressources WebDAV</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="example" id="example">Activation de WebDAV</a></h2>
    <p>Pour activer le module <code class="module"><a href="../mod/mod_dav.html">mod_dav</a></code>, ajoutez la ligne
    suivante  un conteneur de votre fichier <code>httpd.conf</code>
    :</p>

    <pre class="prettyprint lang-config">Dav On</pre>


    <p>Ceci active le fournisseur de systme de fichier DAV implment par
    le module <code class="module"><a href="../mod/mod_dav_fs.html">mod_dav_fs</a></code>. Ce dernier doit donc tre
    compil dans le serveur ou charg au dmarrage  l'aide de la
    directive <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code>.</p>

    <p>En outre, vous devez indiquer o se trouve la base de donnes des
    verrous DAV via une directive <code class="directive"><a href="../mod/mod_dav_fs.html#davlockdb">DavLockDB</a></code> dans la section globale de
    votre fichier <code>httpd.conf</code> :</p>

    <pre class="prettyprint lang-config">DavLockDB /usr/local/apache2/var/DavLock</pre>


    <p>Le rpertoire contenant le fichier de la base de donnes des
    verrous doit avoir des droits en criture pour l'utilisateur et le
    groupe sous lesquels Apache s'excute et dfinis respectivement par
    les directives <code class="directive"><a href="../mod/mod_unixd.html#user">User</a></code> et
    <code class="directive"><a href="../mod/mod_unixd.html#group">Group</a></code>.</p>

    <p>Si vous souhaitez limiter l'accs aux rpertoires o DAV est
    activ, vous pouvez ajouter une clause <code class="directive"><a href="../mod/core.html#limit">&lt;Limit&gt;</a></code> dans la section <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code> considre. Pour
    dfinir la quantit maximale de donnes en octets qu'un client
    DAV peut envoyer par requte, vous devez utiliser la directive
    <code class="directive"><a href="../mod/core.html#limitxmlrequestbody">LimitXMLRequestBody</a></code>, car La
    directive <code class="directive"><a href="../mod/core.html#limitrequestbody">LimitRequestBody</a></code>
    "habituelle" n'a aucune incidence sur les requtes DAV.</p>

    <div class="example"><h3>Exemple complet</h3><pre class="prettyprint lang-config">DavLockDB /usr/local/apache2/var/DavLock

&lt;Directory /usr/local/apache2/htdocs/foo&gt;
    Require all granted
    Dav On

    AuthType Basic
    AuthName DAV
    AuthUserFile user.passwd

    &lt;LimitExcept GET POST OPTIONS&gt;
        Require user admin
    &lt;/LimitExcept&gt;
&lt;/Directory&gt;</pre>
</div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="security" id="security">Problmes concernant la scurit</a></h2>

    <p>Etant donn que les mthodes d'accs DAV permettent  des clients
    distants de manipuler des fichiers sur le serveur, vous devez vous
    assurer que votre serveur est bien scuris avant d'activer
    <code class="module"><a href="../mod/mod_dav.html">mod_dav</a></code>.</p>

    <p>Tout rpertoire du serveur o DAV est activ doit tre protg
    par une procdure d'authentification. L'utilisation de
    l'authentification HTTP de base n'est pas recommande. Vous devez
    utiliser au moins l'authentification HTTP  base de condenss
    qu'implmente le module <code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code>.
    Pratiquement tous les clients WebDAV supportent cette mthode
    d'authentification. Vous pouvez aussi utiliser l'authentification de
    base sur une connexion o <a href="../ssl/">SSL</a> est activ.</p>

    <p>Pour que <code class="module"><a href="../mod/mod_dav.html">mod_dav</a></code> puisse manipuler des fichiers,
    il doit avoir des permissions en criture sur les rpertoires et les
    fichiers qui sont sous son contrle ; en d'autre termes, c'est
    l'utilisateur et le groupe sous lesquels Apache s'excute et dfinis
    par les directives <code class="directive"><a href="../mod/mod_unixd.html#user">User</a></code> et
    <code class="directive"><a href="../mod/mod_unixd.html#group">Group</a></code> qui doivent avoir
    les droits en criture sur ces fichiers et rpertoires. Les fichiers
    nouvellement crs appartiendront aussi  ces utilisateur et groupe.
    Par consquent, il est important de contrler l'accs  ce compte.
    Les rpertoires DAV sont considrs comme privs du point de vue
    d'Apache, et la modification des fichiers qu'ils contiennent
    autrement que par l'intermdiaire d'Apache (par exemple par FTP ou
    par des outils du niveau du systme de fichiers) ne doit pas tre
    permise.</p>

    <p><code class="module"><a href="../mod/mod_dav.html">mod_dav</a></code> peut faire l'objet de plusieurs sortes
    d'attaques par dni de service. La directive <code class="directive"><a href="../mod/core.html#limitxmlrequestbody">LimitXMLRequestBody</a></code> permet de limiter la
    quantit de mmoire consomme pour interprter des requtes DAV de
    grande taille. En outre, la directive <code class="directive"><a href="#davdepthinfinity">DavDepthInfinity</a></code> permet d'empcher les
    requtes <code>PROPFIND</code> concernant un rpertoire de trs
    grande taille de consommer de grandes quantits de mmoire. Un autre
    type d'attaque par dni de service peut aussi tre men par un
    client qui remplit simplement tout l'espace disque disponible avec
    des fichiers de trs grande taille. Etant donn qu'il n'existe aucun
    moyen direct d'viter ce genre d'attaque dans Apache, vous ne devez
    accorder des accs DAV qu' des utilisateurs de confiance.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="complex" id="complex">Configurations complexes</a></h2>

    <p>Les requtes ayant pour but de manipuler des fichiers dynamiques
    (scripts PHP, scripts CGI, etc...) en utilisant
    <code class="module"><a href="../mod/mod_dav.html">mod_dav</a></code> sont courantes. Ce traitement n'est pas
    vident car une requte
    <code>GET</code> va toujours tenter d'excuter le script, plutt que
    de tlcharger son contenu. Pour viter cet inconvnient, une
    mthode possible consiste  faire correspondre deux URLs
    diffrentes au mme contenu, l'une d'entre elles servant  lancer le
    script, alors que l'autre peut tre utilise pour le tlcharger et
    le manipuler avec DAV.</p>

<pre class="prettyprint lang-config">Alias /phparea /home/gstein/php_files
Alias /php-source /home/gstein/php_files
&lt;Location /php-source&gt;
DAV On
ForceType text/plain
&lt;/Location&gt;</pre>


    <p>Avec cette configuration, on peut utiliser
    <code>http://example.com/phparea</code> pour afficher le rsultat de
    l'excution des scripts PHP, et
    <code>http://example.com/php-source</code> pour les manipuler avec
    DAV.</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="Dav" id="Dav">Dav</a> <a name="dav" id="dav">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active les mthodes HTTP WebDAV</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Dav On|Off|<var>nom fournisseur</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Dav Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dav</td></tr>
</table>
    <p>La directive <code class="directive">Dav</code> permet d'activer les
    mthodes HTTP WebDAV pour le conteneur condidr :</p>

    <pre class="prettyprint lang-config">&lt;Location /foo&gt;
    Dav On
&lt;/Location&gt;</pre>


    <p>La valeur <code>On</code> est en fait un alias vers le
    fournisseur par dfaut <code>filesystem</code> implment par le
    module <code class="module"><a href="../mod/mod_dav_fs.html">mod_dav_fs</a></code>. Notez que lorsque DAV est activ
    pour un conteneur, on <em>ne peut pas</em> le dsactiver pour ses
    sous-conteneurs. Pour un exemple de configuration complet,
    reportez-vous  la <a href="#example">section prcdente</a>.</p>

    <div class="warning">
      N'activez pas WebDAV tant que votre serveur n'est pas scuris. Si
      vous passez outre cette recommandation, tout le monde pourra
      enregistrer des fichiers sur votre systme.
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="DavDepthInfinity" id="DavDepthInfinity">DavDepthInfinity</a> <a name="davdepthinfinity" id="davdepthinfinity">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Autorise les requtes PROPFIND avec en-tte Depth:
Infinity</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DavDepthInfinity on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DavDepthInfinity off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dav</td></tr>
</table>
    <p>La directive <code class="directive">DavDepthInfinity</code> permet
    d'autoriser le traitement des requtes <code>PROPFIND</code>
    contenant l'en-tte Depth: Infinity. Par dfaut, ce type de requte
    n'est pas autoris, car il peut favoriser les attaques de type Dni
    de service.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="DavMinTimeout" id="DavMinTimeout">DavMinTimeout</a> <a name="davmintimeout" id="davmintimeout">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dure minimale pendant laquelle le serveur maintient un
verrou sur une ressource DAV</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DavMinTimeout <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DavMinTimeout 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dav</td></tr>
</table>
    <p>Lorsqu'un client demande le verrouillage d'une ressource DAV, il
    peut aussi spcifier une dure au bout de laquelle le verrou sera
    automatiquement supprim par le serveur. Cette valeur ne constitue
    qu'une demande, et le serveur peut l'ignorer ou informer le client
    qu'il va utiliser une valeur arbitraire.</p>

    <p>La directive <code class="directive">DavMinTimeout</code> permet de
    spcifier, en secondes, la dure minimale de verrouillage  renvoyer
    au client. Les Rpertoires Web de Microsoft prsentent une dure par
    dfaut de 120 secondes ; la directive
    <code class="directive">DavMinTimeout</code> permet de dfinir une valeur
    suprieure (par exemple 600 secondes), afin de rduire les risques
    de perte du verrou par le client suite  une surcharge du
    rseau.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">&lt;Location /MSWord&gt;
    DavMinTimeout 600
&lt;/Location&gt;</pre>
</div>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_dav.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_dav.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_dav.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_dav.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_dav.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2014 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>