# frozen_string_literal: true

class AddUniqueIndexOnUuidConvertStringToUuidIncludingVulnerabilityId < Gitlab::Database::Migration[2.1]
  disable_ddl_transaction!

  INDEX_NAME = "index_vuln_findings_on_uuid_including_vuln_id_1"

  def up
    execute <<~SQL
      CREATE UNIQUE INDEX CONCURRENTLY IF NOT EXISTS #{INDEX_NAME}
      ON vulnerability_occurrences(uuid_convert_string_to_uuid)
      INCLUDE(vulnerability_id)
    SQL
  end

  def down
    remove_concurrent_index_by_name(
      :vulnerability_occurrences,
      INDEX_NAME
    )
  end
end
