# frozen_string_literal: true

module Gitlab
  module BackgroundMigration
    # Truncate the Vulnerability html_title if it exceeds 800 chars
    class TruncateOverlongVulnerabilityHtmlTitles < BatchedMigrationJob
      feature_category :vulnerability_management
      scope_to ->(relation) { relation.where("LENGTH(title_html) > 800") }
      operation_name :truncate_vulnerability_title_htmls

      class Vulnerability < ApplicationRecord # rubocop:disable Style/Documentation
        self.table_name = "vulnerabilities"
      end

      def perform
        each_sub_batch do |sub_batch|
          sub_batch.update_all("title_html = left(title_html, 800)")
        end
      end
    end
  end
end
