---
stage: Secure
group: Composition Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Continuous Vulnerability Scanning

DETAILS:
**Tier:** Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/371063) in GitLab 16.4 as an [Experiment](../../../policy/experiment-beta-support.md#experiment) with multiple [feature flags](../../../administration/feature_flags.md) enabled by default.
> - [Feature flags removed](https://gitlab.com/gitlab-org/gitlab/-/issues/425753) in GitLab 16.10.
> - Continuous Container Scanning [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/435435) in GitLab 16.8 [with a flag](../../../administration/feature_flags.md) named `container_scanning_continuous_vulnerability_scans`. Disabled by default.
> - Continuous Container Scanning [enabled on GitLab.com, self-managed, and GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/issues/437162) in GitLab 16.10.

When advisories are added to either the [GitLab Advisory Database](https://advisories.gitlab.com/) or the
[Trivy Database](https://github.com/aquasecurity/trivy-db), Continuous Vulnerability Scanning
triggers a scan on all projects where either Container Scanning, Dependency Scanning, or both, are
enabled. If a new advisory affects an application or operating system dependency, it creates a
vulnerability in the project.

NOTE:
If a new operating system package is added to either the GitLab Advisory Database or Trivy
Database, and an advisory for it already exists, a vulnerability is **not** created. Support for
improvements is proposed in [epic 11219](https://gitlab.com/groups/gitlab-org/-/epics/11219) and
[epic 8026](https://gitlab.com/groups/gitlab-org/-/epics/8026).

## Supported package types

Continuous Vulnerability Scanning supports components with the following [PURL types](https://github.com/package-url/purl-spec/blob/346589846130317464b677bc4eab30bf5040183a/PURL-TYPES.rst):

- `composer`
- `conan`
- `deb`
- `gem`
- `golang`
- `maven`
- `npm`
- `nuget`
- `pypi`

Work to support `apk` and `rpm` package URL types is tracked in [issue 428703](https://gitlab.com/gitlab-org/gitlab/-/issues/428703).

Go pseudo versions are not supported. A project dependency that references a Go pseudo version is
never considered as affected because this might result in false negatives.

## Configuration

To enable Continuous Vulnerability Scanning:

- Enable [Dependency Scanning](../dependency_scanning/index.md#configuration), or [Container Scanning](../container_scanning/index.md#configuration), and ensure that its prerequisites are met.
- On GitLab self-managed only, you can [choose package registry metadata to synchronize](../../../administration/settings/security_and_compliance.md#choose-package-registry-metadata-to-sync) in the Admin Area for the GitLab instance. For this data synchronization to work, you must allow outbound network traffic from your GitLab instance to the domain `storage.googleapis.com`. If you have limited or no network connectivity then refer to the documentation section [running in an offline environment](#running-in-an-offline-environment) for further guidance.

### Running in an offline environment

For self-managed GitLab instances in an environment with limited, restricted, or intermittent access to external resources through the internet,
some adjustments are required to successfully scan CycloneDX reports for vulnerabilities.
For more information, see the offline [quick start guide](../../../topics/offline/quick_start_guide.md#enabling-the-package-metadata-database).

## Checking new vulnerabilities

New vulnerabilities detected by Continuous Vulnerability Scanning are visible on the [Vulnerability Report](../vulnerability_report/index.md).
However, they are not listed on the [Dependency List](../dependency_list/index.md) or in the pipeline where the affected SBOM component was detected.

After an advisory is added to the [`GitLab Advisory Database`](https://advisories.gitlab.com/) or [`Trivy DB`](https://github.com/aquasecurity/trivy-db),
it might take a few hours before the corresponding vulnerabilities are added to your projects.

## Contributing to the vulnerability database

To find a vulnerability, you can search the [`GitLab Advisory Database`](https://advisories.gitlab.com/).
You can also [submit new vulnerabilities](https://gitlab.com/gitlab-org/security-products/gemnasium-db/blob/master/CONTRIBUTING.md).
