// yap.cpp : Defines the class behaviors for the application.
// Time-stamp: "97/01/03 18:23:51 mik"
//
// Copyright (C) 1996, 97
//	Christian Schenk  <cschenk@berlin.snafu.de>
//
// This file is part of MiKTeX.
//
// MiKTeX is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// MiKTeX is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with MiKTeX; if not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "stdafx.h"
#include "yap.h"

#include "mainfrm.h"
#include "dvidoc.h"
#include "dviview.h"
#include "childfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CYapApp

BEGIN_MESSAGE_MAP(CYapApp, CWinApp)
	//{{AFX_MSG_MAP(CYapApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CYapApp construction

CYapApp::CYapApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CYapApp object

CYapApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CYapApp initialization

BOOL CYapApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#if 0
	Enable3dControls();
#endif
 	SetRegistryKey ("MiK\\MiKTeX\\CurrentVersion");
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	CDviDoc::printermode = GetProfileString ("printer", "mode", "");
	CDviDoc::printerres = (long) GetProfileInt ("printer", "hres", 0);
	CDviDoc::displaymode = GetProfileString ("display", "mode", "ibmvga");
	CDviDoc::displayres = (long) GetProfileInt ("display", "hres", 110);
	CDviDoc::displayshrinkfactor = (long) GetProfileInt ("display",
		      "shrinkfactor", 1);
	CDviDoc::pagexshift = (long) GetProfileInt ("printer", "pagexshift", 0);
	CDviDoc::pageyshift = (long) GetProfileInt ("printer", "pageyshift", 0);

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_DVITYPE,
		RUNTIME_CLASS(CDviDoc),
		RUNTIME_CLASS(CChildFrame),          // custom MDI child frame
		RUNTIME_CLASS(CDviView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Enable DDE Execute open
	EnableShellOpen();
	RegisterShellFileTypes();

	// simple command line parsing
	if (m_lpCmdLine[0] == '\0')
	{
#if 0
		// create a new (empty) document
		OnFileNew();
#endif
	}
	else
	{
		// open an existing document
		OpenDocumentFile(m_lpCmdLine);
	}

	// Enable drag/drop open
	m_pMainWnd->DragAcceptFiles();

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CYapApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CYapApp commands

int CYapApp::ExitInstance () 

{
  WriteProfileString ("printer", "mode", CDviDoc::printermode);
  WriteProfileInt ("printer", "hres", CDviDoc::printerres);
  WriteProfileString ("display", "mode", CDviDoc::displaymode);
  WriteProfileInt ("display", "hres", CDviDoc::displayres);
  WriteProfileInt ("display", "shrinkfactor", CDviDoc::displayshrinkfactor);
  WriteProfileInt ("printer", "pagexshift", CDviDoc::pagexshift);
  WriteProfileInt ("printer", "pageyshift", CDviDoc::pageyshift);
  return (CWinApp::ExitInstance());
}
