/* HEX2CHR.C */

#define VERSION "1.0 (beta)"

#include <stdio.h>
#include <string.h>
#ifndef AIX
#include <stdlib.h>
#endif
#include "defines.h"
#include "myopen.h"
#include "pfa2chr.h"

void give_usage ()
{
	fprintf (stderr, "Usage: pfa2chr [<somepfa>[.pfa]|-]");
	fprintf (stderr, " [<somechr>[.chr]|-]\n");
	exit (UNSUCCESSFUL);
}

#ifdef __STDC__
void preamble (int argc, char ** argv)
#else
void preamble (argc, argv)
int argc;
char ** argv;
#endif
{
	if (argc == 1) give_usage ();
	if (strequ (argv [1], "-")) pfa_file = stdin;
	else pfa_file = my_open (argv [1], ".pfa", "r");
	if (argc == 3)
	{
		if (strequ (argv [2], "-")) chr_file = stdout;
		else chr_file = my_open (argv [2], ".chr", "wb");
	}
	else chr_file = my_open (argv [1], ".chr", "wb");
}

void postamble ()
{
	fclose (pfa_file);
	fclose (chr_file);
	exit (SUCCESSFUL);
}

#ifdef __STDC__
unsigned char DeCrypt (unsigned char ch1, unsigned char ch2)
#else
unsigned char DeCrypt (ch1, ch2)
unsigned char ch1, ch2;
#endif
{
	unsigned char plain, cipher;

	if ('A' <= ch1 && ch1 <= 'F') ch1 -= 'A' - 10;
	else if ('a' <= ch1 && ch1 <= 'f') ch1 -= 'a' - 10;
	else ch1 -= '0';
	if ('A' <= ch2 && ch2 <= 'F') ch2 -= 'A' - 10;
	else if ('a' <= ch2 && ch2 <= 'f') ch2 -= 'a' - 10;
	else ch2 -= '0';
	cipher = ch1 * 16 + ch2;
	plain = (cipher ^ (er >> 8));
	er = (cipher + er) * ec1 + ec2;
	return plain;
}

#ifdef __STDC__
void main (int argc, char ** argv)
#else
void main (argc, argv)
int argc;
char ** argv;
#endif
{
	int i, o, in_size;
	int skip_salt = TRUE;
	char * efp;

	fprintf (stderr, "This is pfa2chr, version: %s\n", VERSION);
	preamble (argc, argv);
	while (fgets (in_buff, MAX_BUFFER, pfa_file) != NULL)
	{
		if (strequ (in_buff, "currentfile eexec\n")) break;
		fprintf (chr_file, "%s", in_buff);
	}
	for (;;)
	{
		if (fgets (in_buff, MAX_BUFFER + 1, pfa_file) == NULL) break;
		in_size = strlen (in_buff) - 1;
		if (in_buff [in_size - 1] == '\n') in_size --;
		for (i = o = 0; i < in_size; i += 2)
			out_buff [o ++] = DeCrypt (in_buff [i],
						   in_buff [i + 1]);
		out_buff [o] = '\0';
		if ((efp = strstr (out_buff, "closefile\n")) != NULL)
			o = (efp - out_buff) + 10;
		if (skip_salt)
		{
			fwrite (out_buff + EEXEC_SKIP_BYTES,
				o - EEXEC_SKIP_BYTES, 1, chr_file);
			skip_salt = FALSE;
		}
		else fwrite (out_buff, o, 1, chr_file);
	}
	postamble ();
}
