/* $Id: S_CFGBLD.H 1.1 1994/08/30 02:27:18 kaz Exp kaz $ */

#ifndef s_cfgbld_h_INCLUDED

#ifndef dviprt_for_Ghostscript
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#endif /* !dviprt_for_Ghostscript*/

#include "s_cfg.h"

#ifndef dviprt_for_Ghostscript

#ifdef DVIPRT_GLOBAL_IDENTIFIER
/* make all identifier GLOBAL. For debug. */
#  define private /* */
#else
#  define private static
#endif

typedef unsigned char uchar;
typedef unsigned int uint;
typedef unsigned long ulong;

#ifdef __PROTOTYPES__
#  define P0() void
#  define P1(a) a
#  define P2(a,b) a,b
#  define P3(a,b,c) a,b,c
#  define P4(a,b,c,d) a,b,c,d
#  define P5(a,b,c,d,e) a,b,c,d,e
#  define P6(a,b,c,d,e,f) a,b,c,d,e,f
#  define P7(a,b,c,d,e,f,g) a,b,c,d,e,f,g
#  define P8(a,b,c,d,e,f,g,h) a,b,c,d,e,f,g,h
#  define P9(a,b,c,d,e,f,g,h,i) a,b,c,d,e,f,g,h,i
#else /* !__PROTOTYPES__ */
#  define P0() /* Do nothing */
#  define P1(a)
#  define P2(a,b)
#  define P3(a,b,c)
#  define P4(a,b,c,d)
#  define P5(a,b,c,d,e) 
#  define P6(a,b,c,d,e,f) 
#  define P7(a,b,c,d,e,f,g) 
#  define P8(a,b,c,d,e,f,g,h) 
#  define P9(a,b,c,d,e,f,g,h,i) 
#endif /* __PROTOTYPES__ */

#ifdef __PROTOTYPES__
#  define D0() (void)
#  define D1(a,b) (a b)
#  define D2(a,b,c,d) (a b,c d)
#  define D3(a,b,c,d,e,f) (a b,c d,e f)
#  define D4(a,b,c,d,e,f,g,h) (a b,c d,e f,g h)
#  define D5(a,b,c,d,e,f,g,h,i,j) (a b,c d,e f,g h,i j)
#  define D6(a,b,c,d,e,f,g,h,i,j,k,l) (a b,c d,e f,g h,i j,k l)
#  define D7(a,b,c,d,e,f,g,h,i,j,k,l,m,n) (a b,c d,e f,g h,i j,k l,m n)
#  define D8(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) (a b,c d,e f,g h,i j,k l,m n,o p)
#  define D9(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) \
  (a b,c d,e f,g h,i j,k l,m n,o p,q r)
#else
#  define D0() ()
#  define D1(a,b) (b) a b;
#  define D2(a,b,c,d) (b,d) a b; c d;
#  define D3(a,b,c,d,e,f) (b,d,f) a b; c d; e f;
#  define D4(a,b,c,d,e,f,g,h) (b,d,f,h) a b; c d; e f; g h;
#  define D5(a,b,c,d,e,f,g,h,i,j) \
  (b,d,f,h,j) a b; c d; e f; g h; i j;
#  define D6(a,b,c,d,e,f,g,h,i,j,k,l) \
  (b,d,f,h,j,l) a b; c d; e f; g h; i j; k l;
#  define D7(a,b,c,d,e,f,g,h,i,j,k,l,m,n) \
  (b,d,f,h,j,l,n) a b; c d; e f; g h; i j; k l; m n;
#  define D8(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) \
  (b,d,f,h,j,l,n,p) a b; c d; e f; g h; i j; k l; m n; o p;
#  define D9(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) \
  (b,d,f,h,j,l,n,p,r) a b; c d; e f; g h; i j; k l; m n; o p; q r;
#endif

/* MS-DOS */
#ifdef __MSDOS__
#  define gp_fmode_rb "rb"
#  define gp_fmode_wb "wb"
#  define gp_fmode_binary_suffix "b"
#else
#  define gp_fmode_rb "r"
#  define gp_fmode_wb "w"
#  define gp_fmode_binary_suffix ""
#endif

#endif /* !dviprt_for_Ghostscript */

#define TEMP_CODEBUF_SIZE 1024
#define TEMP_READBUF_SIZE 1024

/* MS-DOS (real-mode) */
#ifdef __MSDOS_REAL__
# define BufferCpy(a,b,c) _fmemcpy(a,b,c)
# define BufferCmp(a,b,c) _fmemcmp(a,b,c)
# define BufferAlloc(a)   _fmalloc(a)
# define BufferFree(a)    _ffree(a)
#else
# define BufferCpy(a,b,c) memcpy(a,b,c)
# define BufferCmp(a,b,c) memcmp(a,b,c)
# define BufferAlloc(a)   malloc(a)
# define BufferFree(a)    free(a)
#endif

#ifndef MIN
#define MIN(a,b) ((a)<(b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a)>(b) ? (a) : (b))
#endif

#define CFG_LIBERROR_UNKNOWN_VALUE  -256
#define CFG_LIBERROR_UNKNOWN_FORMAT -257
#define CFG_LIBERROR_UNKNOWN_ESCSEQ -258
#define CFG_LIBERROR_OUTOFRANGE     -259
#define CFG_LIBERROR_INVALID_VALUE  -260
#define CFG_LIBERROR_COMPLICATED_EXPR  -261
#define CFG_LIBERROR_INCOMPLETE      -262

typedef struct {
  uchar *fname;
  FILE *file;
  int line_no;
  
  char temp_readbuf_f;
  char temp_codebuf_f;
  uchar *readbuf;
  uchar *codebuf;
  int readbuf_size;
  int codebuf_size;
  
  uchar *pcodebuf;
  
  uchar *token;
  uchar *endtoken;
} dviprt_cfg_i;

typedef struct {
  int no;
  long (*getworksize)(P2(dviprt_print *,long ));
  long (*encode)(P3(dviprt_print *,long,int));
} dviprt_encoder;

extern dviprt_encoder *dviprt_getencoder_(P1(int ));
extern int dviprt_setcfgbuffer_(P3(dviprt_cfg_i *,int ,int ));
extern int dviprt_resetcfgbuffer_(P1(dviprt_cfg_i *));
extern int dviprt_initcfg_(P2(dviprt_cfg_t *,dviprt_cfg_i *));
extern int dviprt_printmessage(P2(char *,int ));
extern int dviprt_printerror(P2(char *,int ));
extern int dviprt_printwarning(P2(char *,int ));
extern int dviprt_printcfgerror(P3(dviprt_cfg_i *,char *,int ));
extern int dviprt_printcfgwarning(P3(dviprt_cfg_i *,char *,int ));
extern int dviprt_print_headercomment_(P4(char *,char *,char *,FILE *));
 
extern char dviprt_message_buffer[];
 
#define s_cfgbld_h_INCLUDED
#endif /* s_cfgbld_h_INCLUDED */
