/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.io.File;

public class SimpleFinishPanel
extends IzPanel {
    private static final long serialVersionUID = 3689911781942572085L;
    private VariableSubstitutor vs;

    public SimpleFinishPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        this.vs = new VariableSubstitutor(idata.getVariables());
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.parent.langpack.getString("FinishPanel.done"));
        this.parent.setQuitButtonIcon("done");
        if (this.idata.installSuccess) {
            this.add(LabelFactory.create(this.parent.icons.getImageIcon("check")));
            this.add(IzPanelLayout.createParagraphGap());
            this.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.success"), this.parent.icons.getImageIcon("information"), 10), "nextLine");
            this.add(IzPanelLayout.createParagraphGap());
            if (this.idata.uninstallOutJar != null) {
                String path = this.translatePath("$INSTALL_PATH") + File.separator + "Uninstaller";
                this.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.uninst.info"), this.parent.icons.getImageIcon("information"), 10), "nextLine");
                this.add((Component)LabelFactory.create(path, this.parent.icons.getImageIcon("empty"), 10), "nextLine");
            }
        } else {
            this.add(LabelFactory.create(this.parent.langpack.getString("FinishPanel.fail"), this.parent.icons.getImageIcon("information"), 10));
        }
        this.getLayoutHelper().completeLayout();
    }

    private String translatePath(String destination) {
        destination = this.vs.substitute(destination, null);
        return destination.replace('/', File.separatorChar);
    }
}

