/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.sliq.Tree;

import dmLab.array.FArray;
import dmLab.classifier.attributeIndicators.SliqNodeIndicators;
import dmLab.classifier.sliq.SliqNode;
import dmLab.classifier.sliq.Tree.Node;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.ExperimentIndicators;
import java.util.HashSet;

public abstract class Tree {
    public SliqNode root$81bb75f = null;
    private Node currentNode = null;
    private boolean treeBuildInd = false;
    private boolean treePruneInd = false;
    private float treeBuildingTime = 0.0f;
    private float treePruningTime = 0.0f;
    private int attributesNumber = 0;
    private int maxTreeDepth;

    /*
     * WARNING - void declaration
     */
    public final void setAttributesNumber(int attributesNumber) {
        void var1_1;
        this.attributesNumber = var1_1;
    }

    public final int getAttributesNumber() {
        return this.attributesNumber;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTreeBuildingTime(float treeBuildingTime) {
        void var1_1;
        this.treeBuildingTime = var1_1;
        Tree tree = this;
        this.treeBuildInd = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTreePruningTime(float treePruningTime) {
        void var1_1;
        this.treePruningTime = var1_1;
        Tree tree = this;
        this.treePruneInd = true;
    }

    public final float classifyEvent(FArray events, int eventIndex) {
        this.currentNode = this.root$81bb75f;
        boolean childNull = false;
        boolean child = true;
        while (!this.currentNode.getLeafIndicator() && !childNull) {
            float value = events.readValue(this.currentNode.getSplittingAttrIndex(), eventIndex);
            if (Float.isNaN(value)) {
                child = this.currentNode.left$81bb75f.eventsNumber >= this.currentNode.right$81bb75f.eventsNumber;
            } else {
                float[] splittingValues = this.currentNode.getSplittingValues();
                if (this.currentNode.getSplittingAttrType()) {
                    child = value <= splittingValues[0];
                } else {
                    int i = 0;
                    boolean test = false;
                    do {
                        if (value != splittingValues[i]) continue;
                        child = true;
                        test = true;
                    } while (++i < splittingValues.length && !test);
                    if (!test) {
                        child = false;
                    }
                }
            }
            if (child) {
                if (this.currentNode.left$81bb75f != null) {
                    this.currentNode = this.currentNode.left$81bb75f;
                    continue;
                }
                childNull = true;
                continue;
            }
            if (this.currentNode.right$81bb75f != null) {
                this.currentNode = this.currentNode.right$81bb75f;
                continue;
            }
            childNull = true;
        }
        return this.currentNode.nodeClass;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(FArray trainArray, boolean struct) {
        void var2_3;
        Tree tree;
        StringBuffer tmp = new StringBuffer();
        tmp.append("##### Tree structure #####\n").append('\n');
        this.printNodes((FArray)((Object)tree), this.root$81bb75f, 0, "", tmp);
        tmp.append('\n');
        tmp.append("##### Tree info #####\n");
        tree = this;
        tmp.append("# Nodes number .............. : " + tree.countNodes(tree.root$81bb75f)).append('\n');
        tree = this;
        tmp.append("# Leafs number .............. : " + tree.countLeafs(tree.root$81bb75f)).append('\n');
        tree = this;
        this.maxTreeDepth = 0;
        Tree tree2 = tree;
        tmp.append("# Tree height ............... : " + tree2.evalTreeDepth(tree2.root$81bb75f, 0)).append('\n');
        tree = this;
        tmp.append("# Tree built ................ : " + tree.treeBuildInd).append('\n');
        tree = this;
        tmp.append("# Tree pruned ............... : " + tree.treePruneInd).append('\n');
        tmp.append("# Tree building time [s] .... : " + this.treeBuildingTime).append('\n');
        tmp.append("# Tree pruning time [s] ..... : " + this.treePruningTime).append('\n');
        tmp.append("# Total training time [s] ... : " + (this.treeBuildingTime + this.treePruningTime)).append('\n');
        return var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private int evalTreeDepth(Node node, int treeDepth) {
        if (treeDepth > this.maxTreeDepth) {
            this.maxTreeDepth = treeDepth;
        }
        if (node.left$81bb75f != null) {
            this.evalTreeDepth(node.left$81bb75f, treeDepth + 1);
        }
        if (node.right$81bb75f != null) {
            void var2_2;
            void var1_1;
            this.evalTreeDepth(var1_1.right$81bb75f, (int)(var2_2 + true));
        }
        return this.maxTreeDepth;
    }

    /*
     * WARNING - void declaration
     */
    private int countLeafs(Node node) {
        void var1_1;
        if (node.getLeafIndicator()) {
            return 1;
        }
        return this.countLeafs(node.left$81bb75f) + this.countLeafs(var1_1.right$81bb75f);
    }

    /*
     * WARNING - void declaration
     */
    private int countNodes(Node node) {
        if (!node.getLeafIndicator()) {
            void var1_1;
            return 1 + this.countNodes(node.left$81bb75f) + this.countNodes(var1_1.right$81bb75f);
        }
        return 0;
    }

    private void printNodes(FArray trainArray, Node node, int offset, String direction, StringBuffer tmp) {
        while (true) {
            for (int i = 0; i < offset; ++i) {
                tmp.append("|  ");
            }
            tmp.append(direction);
            if (!node.getLeafIndicator()) {
                int idx = node.getSplittingAttrIndex();
                String name = trainArray.attributes[idx].name;
                tmp.append(name);
                if (node.getSplittingAttrType()) {
                    tmp.append(" <= " + node.getSplittingValues()[0]).append('\n');
                } else {
                    tmp.append(" \\in {");
                    for (int i = 0; i < node.getSplittingValues().length; ++i) {
                        tmp.append(trainArray.dictionary.toString(node.getSplittingValues()[i]));
                        if (i < node.getSplittingValues().length - 1) {
                            tmp.append(",");
                            continue;
                        }
                        tmp.append("}\n");
                    }
                }
            } else {
                tmp.append("[leaf] -> " + trainArray.attributes[trainArray.getDecAttrIdx()].name + " = " + trainArray.dictionary.toString(node.getNodeClass())).append('\n');
            }
            if (node.left$81bb75f != null) {
                this.printNodes(trainArray, node.left$81bb75f, offset + 1, "L:   ", tmp);
            }
            if (node.right$81bb75f == null) break;
            String string = "R:   ";
            ++offset;
            node = node.right$81bb75f;
        }
    }

    public final void addInfo(FArray trainArray, Node node, ExperimentIndicators experimentIndicators, AttributesRI attributesImportance, HashSet<String> attrSet) {
        while (!node.leafIndicator) {
            SliqNodeIndicators nodeIndicators = new SliqNodeIndicators();
            new SliqNodeIndicators().attrEventsNumber = node.eventsNumber;
            nodeIndicators.diversityMeasure = node.diversityMeasure;
            nodeIndicators.goodnessOfSplit = node.goodnessOfSplit;
            int idx = node.getSplittingAttrIndex();
            String attrName = trainArray.attributes[idx].name;
            attributesImportance.addImportances(attrName, experimentIndicators, nodeIndicators);
            attrSet.add(attrName);
            if (node.left$81bb75f != null) {
                this.addInfo(trainArray, node.left$81bb75f, experimentIndicators, attributesImportance, attrSet);
            }
            if (node.right$81bb75f == null) break;
            node = node.right$81bb75f;
        }
    }
}

