/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropMaxElement
extends Propagator<Variable> {
    private final IntVar max;
    private final SetVar set;
    private final int offSet;
    private final int[] weights;
    private final boolean notEmpty;

    public PropMaxElement(SetVar setVar, IntVar max, boolean notEmpty) {
        this(setVar, (int[])null, 0, max, notEmpty);
    }

    public PropMaxElement(SetVar setVar, int[] weights, int offset, IntVar max, boolean notEmpty) {
        super(new Variable[]{setVar, max}, (Priority)PropagatorPriority.BINARY, false);
        this.max = (IntVar)this.vars[1];
        this.set = (SetVar)this.vars[0];
        this.weights = weights;
        this.offSet = offset;
        this.notEmpty = notEmpty;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ISetIterator iter = this.set.getLB().iterator();
        while (iter.hasNext()) {
            this.max.updateLowerBound(this.get(iter.nextInt()), (ICause)this);
        }
        int maxVal = Integer.MIN_VALUE;
        int ub = this.max.getUB();
        iter = this.set.getUB().iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            int k = this.get(j);
            if (k > ub) {
                this.set.remove(j, this);
                continue;
            }
            if (maxVal >= k) continue;
            maxVal = k;
        }
        if (this.notEmpty || this.set.getLB().size() > 0) {
            this.max.updateUpperBound(maxVal, (ICause)this);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.set.getUB().size() == 0) {
            if (this.notEmpty) {
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        int lb = this.max.getLB();
        int ub = this.max.getUB();
        ISetIterator iter = this.set.getLB().iterator();
        while (iter.hasNext()) {
            if (this.get(iter.nextInt()) <= ub) continue;
            return ESat.FALSE;
        }
        int maxVal = Integer.MIN_VALUE;
        iter = this.set.getUB().iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            if (maxVal >= this.get(j)) continue;
            maxVal = this.get(j);
        }
        if (maxVal < lb && (this.notEmpty || this.set.getLB().size() > 0)) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private int get(int j) {
        return this.weights == null ? j : this.weights[j - this.offSet];
    }
}

