/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.algo;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.BitSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.graphOperations.connectivity.StrongConnectivityFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class AlgoAllDiffAC {
    int n;
    int n2;
    DirectedGraph digraph;
    int[] matching;
    int[] nodeSCC;
    BitSet free;
    StrongConnectivityFinder SCCfinder;
    private final int[] father;
    private final BitSet in;
    TIntIntHashMap map;
    int[] fifo;
    protected IntVar[] vars;
    ICause aCause;

    public AlgoAllDiffAC(IntVar[] variables, ICause cause) {
        this.vars = variables;
        this.aCause = cause;
        this.n = this.vars.length;
        this.matching = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.matching[i] = -1;
        }
        this.map = new TIntIntHashMap();
        int idx = this.n;
        for (int i = 0; i < this.n; ++i) {
            IntVar v = this.vars[i];
            int ub = v.getUB();
            int j = v.getLB();
            while (j <= ub) {
                if (!this.map.containsKey(j)) {
                    this.map.put(j, idx);
                    ++idx;
                }
                j = v.nextValue(j);
            }
        }
        this.n2 = idx;
        this.fifo = new int[this.n2];
        this.makeDigraph();
        this.free = new BitSet(this.n2);
        this.father = new int[this.n2];
        this.in = new BitSet(this.n2);
        this.SCCfinder = new StrongConnectivityFinder(this.digraph);
    }

    protected void makeDigraph() {
        this.digraph = new DirectedGraph(this.n2 + 1, SetType.BITSET, false);
    }

    public boolean propagate() throws ContradictionException {
        this.findMaximumMatching();
        return this.filter();
    }

    private void findMaximumMatching() throws ContradictionException {
        int i;
        for (int i2 = 0; i2 < this.n2; ++i2) {
            this.digraph.getSuccessorsOf(i2).clear();
            this.digraph.getPredecessorsOf(i2).clear();
        }
        this.free.set(0, this.n2);
        for (i = 0; i < this.n; ++i) {
            IntVar v = this.vars[i];
            int ub = v.getUB();
            int mate = this.matching[i];
            int k = v.getLB();
            while (k <= ub) {
                int j = this.map.get(k);
                if (mate == j) {
                    assert (this.free.get(i) && this.free.get(j));
                    this.digraph.addEdge(j, i);
                    this.free.clear(i);
                    this.free.clear(j);
                } else {
                    this.digraph.addEdge(i, j);
                }
                k = v.nextValue(k);
            }
        }
        i = this.free.nextSetBit(0);
        while (i >= 0 && i < this.n) {
            this.tryToMatch(i);
            i = this.free.nextSetBit(i + 1);
        }
        for (i = 0; i < this.n; ++i) {
            this.matching[i] = this.digraph.getPredecessorsOf(i).isEmpty() ? -1 : this.digraph.getPredecessorsOf(i).iterator().next();
        }
    }

    private void tryToMatch(int i) throws ContradictionException {
        int mate = this.augmentPath_BFS(i);
        if (mate != -1) {
            this.free.clear(mate);
            this.free.clear(i);
            int tmp = mate;
            while (tmp != i) {
                this.digraph.removeEdge(this.father[tmp], tmp);
                this.digraph.addEdge(tmp, this.father[tmp]);
                tmp = this.father[tmp];
            }
        } else {
            this.vars[0].instantiateTo(this.vars[0].getLB() - 1, this.aCause);
        }
    }

    private int augmentPath_BFS(int root) {
        this.in.clear();
        int indexFirst = 0;
        int indexLast = 0;
        this.fifo[indexLast++] = root;
        while (indexFirst != indexLast) {
            int x = this.fifo[indexFirst++];
            ISetIterator succs = this.digraph.getSuccessorsOf(x).iterator();
            while (succs.hasNext()) {
                int y = succs.nextInt();
                if (this.in.get(y)) continue;
                this.father[y] = x;
                this.fifo[indexLast++] = y;
                this.in.set(y);
                if (!this.free.get(y)) continue;
                return y;
            }
        }
        return -1;
    }

    void buildSCC() {
        if (this.n2 > this.n * 2) {
            this.digraph.removeNode(this.n2);
            this.digraph.addNode(this.n2);
            for (int i = this.n; i < this.n2; ++i) {
                if (this.free.get(i)) {
                    this.digraph.addEdge(i, this.n2);
                    continue;
                }
                this.digraph.addEdge(this.n2, i);
            }
        }
        this.SCCfinder.findAllSCC();
        this.nodeSCC = this.SCCfinder.getNodesSCC();
        this.digraph.removeNode(this.n2);
    }

    void distinguish() {
    }

    boolean filterVar(int i) throws ContradictionException {
        boolean filter = false;
        IntVar v = this.vars[i];
        int ub = v.getUB();
        int k = v.getLB();
        while (k <= ub) {
            int j = this.map.get(k);
            if (this.nodeSCC[i] != this.nodeSCC[j]) {
                if (this.matching[i] == j) {
                    filter |= v.instantiateTo(k, this.aCause);
                } else {
                    filter |= v.removeValue(k, this.aCause);
                    this.digraph.removeEdge(i, j);
                }
            }
            k = v.nextValue(k);
        }
        return filter;
    }

    private boolean filter() throws ContradictionException {
        int i;
        boolean filter = false;
        this.distinguish();
        this.buildSCC();
        for (i = 0; i < this.n; ++i) {
            filter |= this.filterVar(i);
        }
        for (i = 0; i < this.n; ++i) {
            int j;
            IntVar v = this.vars[i];
            if (v.hasEnumeratedDomain()) continue;
            int ub = v.getUB();
            for (int k = v.getLB(); k <= ub; ++k) {
                j = this.map.get(k);
                if (this.digraph.containsEdge(i, j) || this.digraph.containsEdge(j, i)) continue;
                filter |= v.removeValue(k, this.aCause);
            }
            int lb = v.getLB();
            for (int k = v.getUB(); k >= lb; --k) {
                j = this.map.get(k);
                if (this.digraph.containsEdge(i, j) || this.digraph.containsEdge(j, i)) continue;
                filter |= v.removeValue(k, this.aCause);
            }
        }
        return filter;
    }
}

