/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.DocumentFragment;
import nu.xom.Element;
import nu.xom.JaxenConnector;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.XPathContext;
import nu.xom.XPathException;
import nu.xom.jaxen.NamespaceContext;

public abstract class Node {
    private ParentNode parent = null;
    private static NamespaceContext emptyContext = new EmptyNamespaceContext();

    Node() {
    }

    public abstract String getValue();

    public final Document getDocument() {
        Node node;
        for (node = this; node != null && !node.isDocument(); node = node.getParent()) {
        }
        return (Document)node;
    }

    final Node getRoot() {
        ParentNode parentNode = this.getParent();
        if (parentNode == null) {
            return this;
        }
        while (parentNode.getParent() != null) {
            parentNode = parentNode.getParent();
        }
        return parentNode;
    }

    public String getBaseURI() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.getBaseURI();
    }

    public final ParentNode getParent() {
        return this.parent;
    }

    final void setParent(ParentNode parentNode) {
        this.parent = parentNode;
    }

    public void detach() {
        if (this.parent == null) {
            return;
        }
        if (this.isAttribute()) {
            Element element = (Element)this.parent;
            element.removeAttribute((Attribute)this);
        } else {
            this.parent.removeChild(this);
        }
    }

    public abstract Node getChild(int var1);

    public abstract int getChildCount();

    public abstract Node copy();

    public abstract String toXML();

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final Nodes query(String string, XPathContext xPathContext) {
        if (this.isDocType()) {
            throw new XPathException("Can't use XPath on a DocType");
        }
        DocumentFragment documentFragment = null;
        Node node = this.getRoot();
        if (!node.isDocument()) {
            documentFragment = new DocumentFragment();
            documentFragment.appendChild(node);
        }
        try {
            JaxenConnector jaxenConnector = new JaxenConnector(string);
            if (xPathContext == null) {
                jaxenConnector.setNamespaceContext(emptyContext);
            } else {
                jaxenConnector.setNamespaceContext(xPathContext.getJaxenContext());
            }
            List list = jaxenConnector.selectNodes(this);
            Nodes nodes = new Nodes(list);
            return nodes;
        }
        catch (XPathException xPathException) {
            xPathException.setXPath(string);
            throw xPathException;
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException("XPath error: " + exception.getMessage(), exception);
            xPathException.setXPath(string);
            throw xPathException;
        }
        finally {
            if (documentFragment != null) {
                documentFragment.removeChild(0);
            }
        }
    }

    public final Nodes query(String string) {
        return this.query(string, null);
    }

    boolean isElement() {
        return false;
    }

    boolean isText() {
        return false;
    }

    boolean isComment() {
        return false;
    }

    boolean isProcessingInstruction() {
        return false;
    }

    boolean isAttribute() {
        return false;
    }

    boolean isDocument() {
        return false;
    }

    boolean isDocType() {
        return false;
    }

    boolean isDocumentFragment() {
        return false;
    }

    private static class EmptyNamespaceContext
    implements NamespaceContext {
        private EmptyNamespaceContext() {
        }

        @Override
        public String translateNamespacePrefixToUri(String string) {
            return null;
        }
    }
}

