/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;

public abstract class AbstractGraph
implements Graph {
    public boolean addAllEdges(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.addEdge((Edge)iterator.next());
        }
        return bl;
    }

    public boolean addAllVertices(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.addVertex(iterator.next());
        }
        return bl;
    }

    public boolean containsEdge(Object object, Object object2) {
        return this.getEdge(object, object2) != null;
    }

    public boolean removeAllEdges(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.removeEdge((Edge)iterator.next());
        }
        return bl;
    }

    public List removeAllEdges(Object object, Object object2) {
        List list = this.getAllEdges(object, object2);
        this.removeAllEdges(list);
        return list;
    }

    public boolean removeAllVertices(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.removeVertex(iterator.next());
        }
        return bl;
    }

    public String toString() {
        return this.toStringFromSets(this.vertexSet(), this.edgeSet());
    }

    protected boolean assertVertexExist(Object object) {
        if (this.containsVertex(object)) {
            return true;
        }
        if (object == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("no such vertex in graph");
    }

    protected boolean removeAllEdges(Edge[] edgeArray) {
        boolean bl = false;
        for (int i = 0; i < edgeArray.length; ++i) {
            bl |= this.removeEdge(edgeArray[i]);
        }
        return bl;
    }

    protected String toStringFromSets(Collection collection, Collection collection2) {
        return "(" + collection.toString() + ", " + collection2.toString() + ")";
    }
}

