/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import uk.ac.ebi.beam.AddDirectionalLabels;
import uk.ac.ebi.beam.ExplicitToImplicit;
import uk.ac.ebi.beam.FromSubsetAtoms;
import uk.ac.ebi.beam.FromTrigonalTopology;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.ImplicitToExplicit;
import uk.ac.ebi.beam.InvalidSmilesException;
import uk.ac.ebi.beam.NormaliseDirectionalLabels;
import uk.ac.ebi.beam.RenumberAtomMaps;
import uk.ac.ebi.beam.ToSubsetAtoms;
import uk.ac.ebi.beam.ToTrigonalTopology;

public final class Functions {
    private static final ToTrigonalTopology ttt = new ToTrigonalTopology();
    private static final FromTrigonalTopology ftt = new FromTrigonalTopology();
    private static final ExplicitToImplicit eti = new ExplicitToImplicit();
    private static final ImplicitToExplicit ite = new ImplicitToExplicit();
    private static final ToSubsetAtoms tsa = new ToSubsetAtoms();
    private static final FromSubsetAtoms fsa = new FromSubsetAtoms();
    private static final NormaliseDirectionalLabels ndl = new NormaliseDirectionalLabels();
    private static final AddDirectionalLabels adl = new AddDirectionalLabels();
    private static Random rand = new Random();

    private Functions() {
    }

    public static Graph randomise(Graph g) {
        return g.permute(Functions.random(g.order()));
    }

    public static Graph reverse(Graph g) {
        return g.permute(Functions.reverse(g.order()));
    }

    public static Graph atomBasedDBStereo(Graph g) {
        return eti.apply(ttt.apply(ite.apply(g)));
    }

    public static Graph bondBasedDBStereo(Graph g) {
        return eti.apply(ftt.apply(ite.apply(g)));
    }

    public static Graph expand(Graph g) {
        return eti.apply(fsa.apply(ite.apply(g)));
    }

    public static Graph collapse(Graph g) {
        return eti.apply(tsa.apply(ite.apply(g)));
    }

    public static Graph normaliseDirectionalLabels(Graph g) throws InvalidSmilesException {
        if (g.getFlags(8) == 0) {
            return g;
        }
        return ndl.apply(g);
    }

    private static int[] ident(int n) {
        int[] p = new int[n];
        for (int i = 0; i < n; ++i) {
            p[i] = i;
        }
        return p;
    }

    public static Graph canonicalize(Graph g, final long[] labels) {
        Integer[] is = new Integer[g.order()];
        for (int i = 0; i < is.length; ++i) {
            is[i] = i;
        }
        Arrays.sort(is, new Comparator<Integer>(){

            @Override
            public int compare(Integer i, Integer j) {
                if (labels[i] > labels[j]) {
                    return 1;
                }
                if (labels[i] < labels[j]) {
                    return -1;
                }
                return 0;
            }
        });
        int[] p = new int[g.order()];
        for (int i = 0; i < is.length; ++i) {
            p[is[i].intValue()] = i;
        }
        return g.permute(p);
    }

    public static Graph renumberAtomMaps(Graph g) {
        RenumberAtomMaps.renumber(g);
        return g;
    }

    private static int[] random(int n, Random rnd) {
        int[] p = Functions.ident(n);
        for (int i = n; i > 1; --i) {
            Functions.swap(p, i - 1, rnd.nextInt(i));
        }
        return p;
    }

    private static synchronized int[] random(int n) {
        return Functions.random(n, rand);
    }

    private static int[] reverse(int n) {
        int[] p = new int[n];
        for (int i = 0; i < n; ++i) {
            p[i] = n - i - 1;
        }
        return p;
    }

    private static int[] inv(int[] p) {
        int[] q = (int[])p.clone();
        for (int i = 0; i < p.length; ++i) {
            q[p[i]] = i;
        }
        return q;
    }

    private static void swap(int[] p, int i, int j) {
        int tmp = p[i];
        p[i] = p[j];
        p[j] = tmp;
    }
}

