/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.session;

import com.qarks.util.ObjectUID;
import com.qarks.util.session.SessionHandle;
import java.util.Vector;

public class SessionHandler
implements Runnable {
    private static long MAX_PERIOD = 60000L;
    private Vector mSessionHandles = new Vector();
    private long mPeriod;
    private Thread mThread = new Thread(this);
    private static SessionHandler sSessionHandler = null;

    protected SessionHandler() {
        this.mPeriod = MAX_PERIOD;
        this.mThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionHandle(SessionHandle sessionHandle) {
        Vector vector = this.mSessionHandles;
        synchronized (vector) {
            if (this.mSessionHandles.contains(sessionHandle)) {
                this.mSessionHandles.removeElement(sessionHandle);
            }
            this.calculatePeriod();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionHandle getSessionFromObjectUID(ObjectUID objectUID) {
        SessionHandle sessionHandle = null;
        Vector vector = this.mSessionHandles;
        synchronized (vector) {
            for (int i = 0; sessionHandle == null && i < this.mSessionHandles.size(); ++i) {
                sessionHandle = (SessionHandle)this.mSessionHandles.elementAt(i);
                if (sessionHandle.getObjectUID().equals(objectUID)) continue;
                sessionHandle = null;
            }
        }
        if (sessionHandle != null) {
            sessionHandle.resetTimeout();
        }
        return sessionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionHandle(SessionHandle sessionHandle) {
        Vector vector = this.mSessionHandles;
        synchronized (vector) {
            this.mSessionHandles.addElement(sessionHandle);
            sessionHandle.resetTimeout();
        }
        if (this.mPeriod > sessionHandle.getTimeout() / 2L) {
            this.mPeriod = sessionHandle.getTimeout() / 2L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean bl = false;
        while (true) {
            try {
                while (true) {
                    if (bl) {
                        this.calculatePeriod();
                        bl = false;
                    }
                    Thread.currentThread();
                    Thread.sleep(this.mPeriod);
                    Vector vector = this.mSessionHandles;
                    synchronized (vector) {
                        int n = 0;
                        while (n < this.mSessionHandles.size()) {
                            SessionHandle sessionHandle = (SessionHandle)this.mSessionHandles.elementAt(n);
                            long l = System.currentTimeMillis();
                            if (l - sessionHandle.getLastAccessTime() > sessionHandle.getTimeout()) {
                                bl = true;
                                this.mSessionHandles.removeElement(sessionHandle);
                                sessionHandle.notifyExpiration();
                                continue;
                            }
                            ++n;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    public SessionHandle createSessionHandle(long l) {
        SessionHandle sessionHandle = new SessionHandle(l);
        sessionHandle.setObjectUID(ObjectUID.getNewObjectUID());
        return sessionHandle;
    }

    public static synchronized SessionHandler getInstance() {
        if (sSessionHandler == null) {
            sSessionHandler = new SessionHandler();
        }
        return sSessionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculatePeriod() {
        Vector vector = this.mSessionHandles;
        synchronized (vector) {
            long l = MAX_PERIOD;
            for (int i = 0; i < this.mSessionHandles.size(); ++i) {
                long l2 = ((SessionHandle)this.mSessionHandles.elementAt(i)).getTimeout();
                if (l2 / 2L >= l) continue;
                l = l2 / 2L;
            }
            this.mPeriod = Math.min(MAX_PERIOD, l);
        }
    }
}

