/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class RegexFileFilter
implements FileFilter {
    Pattern absolutePathRegex;
    Pattern nameRegex;

    public RegexFileFilter(Pattern absolutePathRegex, Pattern filenameRegex) {
        this.absolutePathRegex = absolutePathRegex;
        this.nameRegex = filenameRegex;
    }

    public RegexFileFilter(String absolutePathRegex, String filenameRegex) {
        this(absolutePathRegex != null ? Pattern.compile(absolutePathRegex) : null, filenameRegex != null ? Pattern.compile(filenameRegex) : null);
    }

    public RegexFileFilter(Pattern nameRegex) {
        this(null, nameRegex);
    }

    public RegexFileFilter(String filenameRegex) {
        this(filenameRegex != null ? Pattern.compile(filenameRegex) : null);
    }

    @Override
    public boolean accept(File f) {
        boolean ret = !(this.absolutePathRegex != null && !this.absolutePathRegex.matcher(f.getAbsolutePath()).matches() || this.nameRegex != null && !this.nameRegex.matcher(f.getName()).matches());
        return ret;
    }
}

