/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.BaggingClassifier;
import cc.mallet.classify.Classifier;
import cc.mallet.classify.ClassifierTrainer;
import cc.mallet.types.InstanceList;
import java.util.Random;

public class BaggingTrainer
extends ClassifierTrainer<BaggingClassifier> {
    ClassifierTrainer.Factory underlyingTrainer;
    int numBags;
    BaggingClassifier classifier;

    @Override
    public BaggingClassifier getClassifier() {
        return this.classifier;
    }

    public BaggingTrainer(ClassifierTrainer.Factory underlyingTrainerFactory, int numBags) {
        this.underlyingTrainer = underlyingTrainerFactory;
        this.numBags = numBags;
    }

    public BaggingTrainer(ClassifierTrainer.Factory underlyingTrainerFactory) {
        this(underlyingTrainerFactory, 10);
    }

    @Override
    public BaggingClassifier train(InstanceList trainingList) {
        Classifier[] classifiers = new Classifier[this.numBags];
        Random r = new Random();
        for (int round = 0; round < this.numBags; ++round) {
            InstanceList bag = trainingList.sampleWithReplacement(r, trainingList.size());
            classifiers[round] = ((ClassifierTrainer)this.underlyingTrainer.newClassifierTrainer()).train(bag);
        }
        this.classifier = new BaggingClassifier(trainingList.getPipe(), classifiers);
        return this.classifier;
    }
}

