/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.SimpleNode;
import java.lang.reflect.InvocationTargetException;

public class TargetError
extends EvalError {
    Throwable target;

    public TargetError(String string, Throwable throwable, SimpleNode simpleNode) {
        super(string, simpleNode);
        this.target = throwable;
    }

    public TargetError(Throwable throwable, SimpleNode simpleNode) {
        this("TargetError", throwable, simpleNode);
    }

    public TargetError(String string, Throwable throwable) {
        this(string, throwable, null);
    }

    public Throwable getTarget() {
        if (this.target instanceof InvocationTargetException) {
            return ((InvocationTargetException)this.target).getTargetException();
        }
        return this.target;
    }

    public String toString() {
        return super.toString() + "\nTarget exception: " + this.printTargetError(this.target);
    }

    public void printStackTrace() {
        super.printStackTrace();
        System.out.println("--- Target Stack Trace ---");
        this.target.printStackTrace();
    }

    public void reThrow(String string) throws TargetError {
        throw new TargetError(string + ":" + this.getMessage(), this.target, this.node);
    }

    public void reThrow(String string, SimpleNode simpleNode) throws TargetError {
        String string2 = string == null ? "" : string + " : ";
        throw new TargetError(string2 + this.getMessage(), this.target, simpleNode);
    }

    public void reThrow(SimpleNode simpleNode) throws TargetError {
        this.reThrow(null, simpleNode);
    }

    public String printTargetError(Throwable throwable) {
        String string = this.target.toString();
        if (Capabilities.canGenerateInterfaces()) {
            string = string + "\n" + this.xPrintTargetError(throwable);
        }
        return string;
    }

    public String xPrintTargetError(Throwable throwable) {
        String string = "import java.lang.reflect.UndeclaredThrowableException;if ( target instanceof UndeclaredThrowableException )\treturn target.getUndeclaredThrowable().toString();else return \"\"";
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("target", throwable);
            return (String)interpreter.eval(string);
        }
        catch (EvalError evalError) {
            throw new InterpreterError("xprintarget: " + evalError.toString());
        }
    }
}

