## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ---- eval=FALSE--------------------------------------------------------------
#  install.packages("bifurcatingr")

## -----------------------------------------------------------------------------
library(bifurcatingr)

## -----------------------------------------------------------------------------
dat<-bfa_tree_gen(n=127,p=1,s1=1,s2=2,r1=0.5,r2=0.5,g=0.2,intercept=10,ar_coef=c(0.7))
dat <- round(dat,1)
dat

## ----out.width="75%",dpi=750--------------------------------------------------
bfa_tree_plot(ecoli$lifetime, vertex.size = 10, shape = "circle", text.size = 0.3, vertex.color = "white",vertex.asp = 0.5, arrow.size = 0.2, arrow.width = 0.3, plot.margin = 0)

## ----out.width="75%",dpi=750--------------------------------------------------
bfa_scatterplot(dat,1)

## ----out.width="75%",dpi=750--------------------------------------------------
bfa_scatterplot(dat,2)

## -----------------------------------------------------------------------------
bfa_ls(dat,p=1,conf=TRUE,cov_matrix=TRUE,conf_level=0.9,p_value=TRUE)

## -----------------------------------------------------------------------------
bfa_ls_bc(dat,p = 1, method = "boot1",B1 = 999, B2 = 499)

## -----------------------------------------------------------------------------
bfa_ls_bc(dat,p = 1, method = "boot2fast",B1 = 999, B2 = 499)

## -----------------------------------------------------------------------------
bfa_ls_bc(dat, p=1, method="LBC")

## -----------------------------------------------------------------------------
bfa_ls_bc_ci(dat, p=1, method="BCa", B=4)

## -----------------------------------------------------------------------------
bfa_ls_bc_ci(dat, p=1, method="boot1", B=4)

