/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Phase;
import beagleutil.Samples;
import haplotype.BitHapPair;
import haplotype.HapPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import vcf.Markers;
import vcf.VcfRecord;

public class ConsensusPhaser {
    private ConsensusPhaser() {
    }

    public static List<HapPair> run(List<HapPair> list) {
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(list);
        if (arrayList.isEmpty()) {
            return arrayList;
        }
        ConsensusPhaser.checkMarkers(arrayList);
        Random random = new Random(arrayList.size());
        Collections.sort(arrayList, ConsensusPhaser.hapsComparator());
        ArrayList<HapPair> arrayList2 = new ArrayList<HapPair>(arrayList.size() / 20);
        int n = 0;
        while (n < arrayList.size()) {
            int n2;
            for (n2 = n + 1; n2 < arrayList.size() && ((HapPair)arrayList.get(n2)).sampleIndex() == ((HapPair)arrayList.get(n)).sampleIndex(); ++n2) {
            }
            if (n2 - n == 1) {
                arrayList2.add((HapPair)arrayList.get(n));
            } else {
                arrayList2.add(ConsensusPhaser.consensus(arrayList.subList(n, n2), random));
            }
            n = n2;
        }
        return arrayList2;
    }

    private static void checkMarkers(List<HapPair> list) {
        Markers markers = list.get(0).markers();
        Samples samples = list.get(0).samples();
        for (int i = 1; i < list.size(); ++i) {
            if (!markers.equals(list.get(i).markers())) {
                throw new IllegalArgumentException("inconsistent markers");
            }
            if (samples.equals(list.get(i).samples())) continue;
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    private static HapPair consensus(List<HapPair> list, Random random) {
        HapPair hapPair = list.get(0);
        int n = hapPair.sampleIndex();
        Samples samples = hapPair.samples();
        Markers markers = hapPair.markers();
        int n2 = markers.nMarkers();
        Phase phase = null;
        Phase[] phaseArray = new Phase[list.size()];
        Phase[] phaseArray2 = new Phase[list.size()];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = ConsensusPhaser.hapPairWithConsensusGT(list, markers, i, random);
            int n5 = list.get(n4).allele1(i);
            if (n5 != (n3 = list.get(n4).allele2(i))) {
                Phase[] phaseArray3;
                ConsensusPhaser.storePhase(list, i, n5, n3, phaseArray2);
                if (phase != null) {
                    Phase phase2;
                    phaseArray3 = ConsensusPhaser.relPhase(phaseArray, phaseArray2, random);
                    if (phaseArray3 == Phase.IDENTICAL) {
                        phase2 = phase;
                    } else {
                        assert (phaseArray3 == Phase.OPPOSITE);
                        phase2 = ConsensusPhaser.flip(phase);
                    }
                    if (phase2 == Phase.IDENTICAL && n5 > n3 || phase2 == Phase.OPPOSITE && n5 < n3) {
                        int n6 = n5;
                        n5 = n3;
                        n3 = n6;
                    }
                }
                phase = n5 < n3 ? Phase.IDENTICAL : Phase.OPPOSITE;
                phaseArray3 = phaseArray2;
                phaseArray2 = phaseArray;
                phaseArray = phaseArray3;
            }
            nArray[i] = n5;
            nArray2[i] = n3;
        }
        return new BitHapPair(markers, samples, n, nArray, nArray2);
    }

    private static Phase flip(Phase phase) {
        if (phase == Phase.IDENTICAL) {
            return Phase.OPPOSITE;
        }
        if (phase == Phase.OPPOSITE) {
            return Phase.IDENTICAL;
        }
        throw new IllegalArgumentException(phase.toString());
    }

    private static int hapPairWithConsensusGT(List<HapPair> list, Markers markers, int n, Random random) {
        int n2 = ConsensusPhaser.consensusGT(list, markers, n, random);
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            int n4;
            HapPair hapPair = list.get(i);
            int n5 = hapPair.allele1(n);
            if (VcfRecord.gtIndex(n5, n4 = hapPair.allele2(n)) != n2) continue;
            return i;
        }
        assert (false);
        throw new IllegalArgumentException("no sample with consensus GT");
    }

    private static int consensusGT(List<HapPair> list, Markers markers, int n, Random random) {
        int n2;
        int[] nArray = ConsensusPhaser.gtCounts(list, markers, n);
        int n3 = n2 = random.nextInt(nArray.length);
        for (int i = 1; i < nArray.length; ++i) {
            int n4 = n2 + i;
            if (n4 >= nArray.length) {
                n4 -= nArray.length;
            }
            if (nArray[n4] <= nArray[n3]) continue;
            n3 = n4;
        }
        return n3;
    }

    private static int[] gtCounts(List<HapPair> list, Markers markers, int n) {
        int n2 = markers.marker(n).nGenotypes();
        int[] nArray = new int[n2];
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            int n4;
            HapPair hapPair = list.get(i);
            int n5 = hapPair.allele1(n);
            int n6 = hapPair.allele2(n);
            int n7 = n4 = VcfRecord.gtIndex(n5, n6);
            nArray[n7] = nArray[n7] + 1;
        }
        return nArray;
    }

    private static void storePhase(List<HapPair> list, int n, int n2, int n3, Phase[] phaseArray) {
        assert (phaseArray.length == list.size());
        for (int i = 0; i < phaseArray.length; ++i) {
            int n4 = list.get(i).allele1(n);
            int n5 = list.get(i).allele2(n);
            phaseArray[i] = n2 == n4 && n3 == n5 || n2 == n5 && n3 == n4 ? (n4 < n5 ? Phase.IDENTICAL : Phase.OPPOSITE) : Phase.INCONSISTENT;
        }
    }

    private static Phase relPhase(Phase[] phaseArray, Phase[] phaseArray2, Random random) {
        assert (phaseArray.length == phaseArray2.length);
        int n = 0;
        int n2 = 0;
        block8: for (int i = 0; i < phaseArray.length; ++i) {
            if (phaseArray[i] == Phase.IDENTICAL) {
                switch (phaseArray2[i]) {
                    case IDENTICAL: {
                        ++n;
                        break;
                    }
                    case OPPOSITE: {
                        ++n2;
                    }
                }
                continue;
            }
            if (phaseArray[i] != Phase.OPPOSITE) continue;
            switch (phaseArray2[i]) {
                case IDENTICAL: {
                    ++n2;
                    continue block8;
                }
                case OPPOSITE: {
                    ++n;
                }
            }
        }
        if (n > n2) {
            return Phase.IDENTICAL;
        }
        if (n2 > n) {
            return Phase.OPPOSITE;
        }
        return random.nextBoolean() ? Phase.IDENTICAL : Phase.OPPOSITE;
    }

    private static Comparator<HapPair> hapsComparator() {
        return (hapPair, hapPair2) -> {
            int n;
            int n2 = hapPair.sampleIndex();
            if (n2 == (n = hapPair2.sampleIndex())) {
                return 0;
            }
            return n2 < n ? -1 : 1;
        };
    }
}

