## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(dplyr)

## ----build--------------------------------------------------------------------
  fun <- repfun::ru_setdata(head(mtcars,5),head(airquality,5))
  fun[['Row.names']] <- as.character(fun$Row.names)

## ----results------------------------------------------------------------------
knitr::kable(fun, caption = "Combining Data Frames with Different Columns")

