/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Arrays;
import java.util.BitSet;
import org.openscience.cdk.graph.EdmondsMaximumMatching;

public final class Matching {
    private static final int NIL = -1;
    private final int[] match;

    private Matching(int n) {
        this.match = new int[n];
        Arrays.fill(this.match, -1);
    }

    public void match(int u, int v) {
        this.match[u] = v;
        this.match[v] = u;
    }

    public int other(int v) {
        if (this.unmatched(v)) {
            throw new IllegalArgumentException(v + " is not matched");
        }
        return this.match[v];
    }

    public void unmatch(int v) {
        this.match[v] = -1;
    }

    public boolean matched(int v) {
        return !this.unmatched(v);
    }

    public boolean unmatched(int v) {
        return this.match[v] == -1 || this.match[this.match[v]] != v;
    }

    public boolean perfect(int[][] graph, BitSet subset) {
        if (graph.length != this.match.length || subset.cardinality() > graph.length) {
            throw new IllegalArgumentException("graph and matching had different capacity");
        }
        if ((subset.cardinality() & 1) == 1) {
            return false;
        }
        if (this.arbitaryMatching(graph, subset)) {
            return true;
        }
        EdmondsMaximumMatching.maxamise(this, graph, subset);
        int v = subset.nextSetBit(0);
        while (v >= 0) {
            if (this.unmatched(v)) {
                return false;
            }
            v = subset.nextSetBit(v + 1);
        }
        return true;
    }

    boolean arbitaryMatching(int[][] graph, BitSet subset) {
        BitSet unmatched = new BitSet();
        int[] deg = new int[graph.length];
        int[] deg1 = new int[graph.length];
        int nd1 = 0;
        int nMatched = 0;
        int v = subset.nextSetBit(0);
        while (v >= 0) {
            if (this.matched(v)) {
                assert (subset.get(this.other(v)));
                ++nMatched;
            } else {
                unmatched.set(v);
                for (int w : graph[v]) {
                    if (!subset.get(w) || !this.unmatched(w)) continue;
                    int n = v;
                    deg[n] = deg[n] + 1;
                }
                if (deg[v] == 1) {
                    deg1[nd1++] = v;
                }
            }
            v = subset.nextSetBit(v + 1);
        }
        block2: while (!unmatched.isEmpty()) {
            v = -1;
            while (nd1 > 0 && !unmatched.get(v = deg1[--nd1])) {
            }
            if (v < 0 || unmatched.get(v)) {
                v = unmatched.nextSetBit(0);
            }
            unmatched.clear(v);
            for (int w : graph[v]) {
                int u;
                int n;
                if (!unmatched.get(w)) continue;
                this.match(v, w);
                nMatched += 2;
                unmatched.clear(w);
                int[] nArray = graph[w];
                int n2 = nArray.length;
                for (n = 0; n < n2; ++n) {
                    int n3 = u = nArray[n];
                    deg[n3] = deg[n3] - 1;
                    if (deg[n3] != 1 || !unmatched.get(u)) continue;
                    deg1[nd1++] = u;
                }
                if (deg[v] <= 1) continue block2;
                nArray = graph[v];
                n2 = nArray.length;
                for (n = 0; n < n2; ++n) {
                    int n4 = u = nArray[n];
                    deg[n4] = deg[n4] - 1;
                    if (deg[n4] != 1 || !unmatched.get(u)) continue;
                    deg1[nd1++] = u;
                }
                continue block2;
            }
        }
        return nMatched == subset.cardinality();
    }

    public static Matching withCapacity(int capacity) {
        return new Matching(capacity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(4 * this.match.length);
        sb.append('[');
        for (int u = 0; u < this.match.length; ++u) {
            int v = this.match[u];
            if (v <= u || this.match[v] != u) continue;
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(u).append('=').append(v);
        }
        sb.append(']');
        return sb.toString();
    }
}

