## ----echo = FALSE, message=FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(dRiftDM)
set.seed(1014)

## -----------------------------------------------------------------------------
model <- ratcliff_dm()

## -----------------------------------------------------------------------------
coef(model)

## -----------------------------------------------------------------------------
coef(model)["muc"] <- 2.5
coef(model)["b"] <- 0.5
coef(model)

## -----------------------------------------------------------------------------
set.seed(1)
traces <- simulate_traces(model, k = 10)
plot(traces, col = "black")

## -----------------------------------------------------------------------------
prms_solve(model)["dt"] = .001 # set to 1 ms step size (for a nice plot)
set.seed(1)
traces <- simulate_traces(model, k = 10)
plot(traces, col = "black")

## -----------------------------------------------------------------------------
traces <- simulate_traces(model, k = 1, sigma = 0)
plot(traces, col = "black")

## -----------------------------------------------------------------------------
prms_solve(model)["dt"] = .010 # set it back to a 10 ms step size (for speed)
calc_stats(model, type = "basic_stats")

## -----------------------------------------------------------------------------
par(mfcol = c(1, 2))

# define the parameter ranges
muc_seq <- seq(1.5, 5.0, by = 0.5)
b_seq <- seq(0.2, 0.9, by = 0.1)
t0_seq <- seq(0.1, 0.45, by = 0.05)

# small helper function
get_stats <- function(prm_val, prm_label) {
  coef(model)[prm_label] <- prm_val
  stats <- calc_stats(model, type = "basic_stats")
  stats <- stats[c("Mean_corr", "P_corr")]
  return(as.numeric(stats))
}

# Drift Rate Plots
par(mfcol = c(1, 2))
stats_mu <- sapply(muc_seq, get_stats, prm_label = "muc")
plot(stats_mu[1, ] ~ muc_seq,
  type = "l",
  ylim = c(0.2, 0.8), xlab = "muc", ylab = "correct RTs", main = "Influence: Drift Rate"
)
plot(stats_mu[2, ] ~ muc_seq,
  type = "l",
  ylim = c(0.5, 1), xlab = "muc", ylab = "Accuarcy", main = "Influence: Drift Rate"
)

# Boundary Plots
par(mfcol = c(1, 2))
stats_b <- sapply(b_seq, get_stats, prm_label = "b")
plot(stats_b[1, ] ~ b_seq,
  type = "l",
  ylim = c(0.2, 0.8), xlab = "b", ylab = "correct RTs", main = "Influence: Boundary"
)
plot(stats_b[2, ] ~ b_seq,
  type = "l",
  ylim = c(0.5, 1), xlab = "b", ylab = "Accuarcy", main = "Influence: Boundary"
)

# Non-Decision Time Plots
par(mfcol = c(1, 2))
stats_non_dec <- sapply(t0_seq, get_stats, prm_label = "non_dec")
plot(stats_non_dec[1, ] ~ t0_seq,
  type = "l",
  ylim = c(0.2, 0.8), xlab = "non_dec", ylab = "correct RTs", main = "Influence: Non-Decision Time"
)
plot(stats_non_dec[2, ] ~ t0_seq,
  type = "l",
  ylim = c(0.5, 1), xlab = "non_dec", ylab = "Accuarcy", main = "Influence: Non-Decision Time"
)

