/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.AbstractC;

import java.util.ArrayList;
import java.util.Vector;
import moa.clusterers.outliers.AbstractC.ISBIndex;
import moa.clusterers.outliers.MyBaseOutlierDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCBase
extends MyBaseOutlierDetector {
    protected static final Long FIRST_OBJ_ID = 1L;
    protected Long objId;
    protected Vector<ISBIndex.ISBNode> windowNodes;
    protected ISBIndex ISB;
    protected int m_WindowSize;
    protected double m_radius;
    protected double m_Fraction;
    protected boolean bWarning = false;
    public int m_nBothInlierOutlier;
    public int m_nOnlyInlier;
    public int m_nOnlyOutlier;

    @Override
    public String getObjectInfo(Object obj) {
        int i;
        if (obj == null) {
            return null;
        }
        ISBIndex.ISBNode node = (ISBIndex.ISBNode)obj;
        ArrayList<String> infoTitle = new ArrayList<String>();
        ArrayList<String> infoValue = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < node.obj.dimensions(); ++i) {
            infoTitle.add("Dim" + (i + 1));
            infoValue.add(String.format("%.3f", node.obj.get(i)));
        }
        infoTitle.add("id");
        infoValue.add(String.format("%d", node.id));
        sb.append("<html>");
        sb.append("<table>");
        for (i = 0; i < infoTitle.size() && i < infoValue.size(); ++i) {
            sb.append("<tr><td><b>" + (String)infoTitle.get(i) + ":</b></td><td>" + (String)infoValue.get(i) + "</td></tr>");
        }
        sb.append("</table>");
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public String getStatistics() {
        StringBuilder sb = new StringBuilder();
        sb.append("Statistics:\n\n");
        int nBothInlierOutlier = this.m_nBothInlierOutlier;
        int nOnlyInlier = this.m_nOnlyInlier;
        int nOnlyOutlier = this.m_nOnlyOutlier;
        for (ISBIndex.ISBNode node : this.windowNodes) {
            if (node.nInlier > 0 && node.nOutlier > 0) {
                ++nBothInlierOutlier;
                continue;
            }
            if (node.nInlier > 0) {
                ++nOnlyInlier;
                continue;
            }
            ++nOnlyOutlier;
        }
        int sum = nBothInlierOutlier + nOnlyInlier + nOnlyOutlier;
        if (sum > 0) {
            sb.append(String.format("  Nodes always inlier: %d (%.1f%%)\n", nOnlyInlier, (double)(100 * nOnlyInlier) / (double)sum));
            sb.append(String.format("  Nodes always outlier: %d (%.1f%%)\n", nOnlyOutlier, (double)(100 * nOnlyOutlier) / (double)sum));
            sb.append(String.format("  Nodes both inlier and outlier: %d (%.1f%%)\n", nBothInlierOutlier, (double)(100 * nBothInlierOutlier) / (double)sum));
            sb.append("  (Sum: " + sum + ")\n");
        }
        sb.append("\n  Total range queries: " + this.nRangeQueriesExecuted + "\n");
        sb.append("  Max memory usage: " + this.iMaxMemUsage + " MB\n");
        sb.append("  Total process time: " + String.format("%.2f ms", (double)this.nTotalRunTime.longValue() / 1000.0) + "\n");
        return sb.toString();
    }

    Long GetWindowEnd() {
        return this.objId - 1L;
    }

    Long GetWindowStart() {
        Long x = this.GetWindowEnd() - (long)this.m_WindowSize + 1L;
        if (x < FIRST_OBJ_ID) {
            x = FIRST_OBJ_ID;
        }
        return x;
    }

    boolean IsWinFull() {
        return this.GetWindowEnd() >= FIRST_OBJ_ID + (long)this.m_WindowSize - 1L;
    }

    Long GetExpirationTime(ISBIndex.ISBNode node) {
        return node.id + (long)this.m_WindowSize;
    }

    void AddNode(ISBIndex.ISBNode node) {
        this.windowNodes.add(node);
        this.ISB.Insert(node);
    }

    void RemoveNode(ISBIndex.ISBNode node) {
        this.windowNodes.remove(node);
        this.ISB.Remove(node);
        this.RemoveExpiredOutlier(new MyBaseOutlierDetector.Outlier(node.inst, node.id, node));
        if (node.nInlier > 0 && node.nOutlier > 0) {
            ++this.m_nBothInlierOutlier;
        } else if (node.nInlier > 0) {
            ++this.m_nOnlyInlier;
        } else {
            ++this.m_nOnlyOutlier;
        }
    }

    ISBIndex.ISBNode GetExpiredNode() {
        if (this.windowNodes.size() <= 0) {
            return null;
        }
        ISBIndex.ISBNode node = this.windowNodes.get(0);
        if (node.id < this.GetWindowStart()) {
            return node;
        }
        return null;
    }

    void SaveOutlier(ISBIndex.ISBNode node) {
        this.AddOutlier(new MyBaseOutlierDetector.Outlier(node.inst, node.id, node));
        ++node.nOutlier;
    }

    void RemoveOutlier(ISBIndex.ISBNode node) {
        this.RemoveOutlier(new MyBaseOutlierDetector.Outlier(node.inst, node.id, node));
        ++node.nInlier;
    }

    @Override
    protected boolean IsNodeIdInWin(long id) {
        return this.GetWindowStart() <= id && id <= this.GetWindowEnd();
    }

    void PrintWindow() {
        this.Println("Window [" + this.GetWindowStart() + "-" + this.GetWindowEnd() + "]: ");
        for (int i = 0; i < this.windowNodes.size(); ++i) {
            ISBIndex.ISBNode node = this.windowNodes.get(i);
            this.Print("   Node: ");
            this.PrintNode(node);
        }
    }

    void PrintNode(ISBIndex.ISBNode n) {
        this.Print("id=" + n.id + " (");
        int dim = n.obj.dimensions();
        for (int d = 0; d < dim; ++d) {
            this.Print(Double.toString(n.obj.get(d)));
            if (d >= dim - 1) continue;
            this.Print(", ");
        }
        this.Println(")");
    }

    public void Print_lt_cnt(ArrayList<Integer> lt_cnt) {
        for (int i = 0; i < lt_cnt.size(); ++i) {
            this.Print("(" + i + ": " + lt_cnt.get(i) + ") ");
        }
        this.Println("");
    }
}

