/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.IterativePartitioningFilter;

import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Parameters {
    private static BufferedReader br;
    public static String algorithmName;
    public static String trainInputFile;
    public static String testInputFile;
    public static String trainOutputFile;
    public static String testOutputFile;
    public static String logOutputFile;
    public static int numClasses;
    public static int numAttributes;
    public static int numInstances;
    public static long seed;
    public static int numPartitions;
    public static String filterType;
    public static boolean prune;
    public static double confidence;
    public static int itemsetsPerLeaf;

    public static void doParse(String fileName) {
        try {
            br = new BufferedReader(new FileReader(fileName));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Parameters.parseParameters();
        System.out.println("Parameters correctly parsed");
    }

    static void parseParameters() {
        String str = Parameters.getLine();
        while (str != null) {
            System.out.println("Line: " + str);
            StringTokenizer st = new StringTokenizer(str, "=");
            String name = st.nextToken();
            name = name.trim();
            if (name.equalsIgnoreCase("algorithm")) {
                Parameters.processAlgorithmName(st);
            } else if (name.equalsIgnoreCase("inputData")) {
                Parameters.processInputs(st);
            } else if (name.equalsIgnoreCase("outputData")) {
                Parameters.processOutputs(st);
            } else {
                Parameters.processParameters(st, name);
            }
            str = Parameters.getLine();
        }
    }

    static void processAlgorithmName(StringTokenizer st) {
        if (!st.hasMoreTokens()) {
            System.err.println("Parse error processing algorithm name");
            System.exit(1);
        }
        String name = st.nextToken();
        name = name.trim();
        System.out.println("The name is: " + name);
        if (!Parameters.validateAlgorithmName(name)) {
            System.err.println("This config file is not for us: " + name);
            System.exit(1);
        }
        algorithmName = new String(name);
        System.out.println("Returning from processAlgorithmName");
    }

    static void processInputs(StringTokenizer st) {
        if (!st.hasMoreTokens()) {
            System.err.println("Parse error processing inputs");
            System.exit(1);
        }
        String files = st.nextToken();
        if (!(files = files.trim()).startsWith("\"") || !files.endsWith("\"")) {
            System.err.println("Parse error processing inputs " + files);
            System.exit(1);
        }
        files.replaceAll("^\"", "");
        files.replaceAll("\"$", "");
        StringTokenizer st2 = new StringTokenizer(files, "\"");
        try {
            String file1 = st2.nextToken();
            st2.nextToken();
            String file2 = st2.nextToken();
            Parameters.insertStringParameter("trainInputFile", file1);
            Parameters.insertStringParameter("testInputFile", file2);
        }
        catch (NoSuchElementException e) {
            System.err.println("Parse error processing inputs " + files);
            System.exit(1);
        }
    }

    static void processOutputs(StringTokenizer st) {
        if (!st.hasMoreTokens()) {
            System.err.println("Parse error processing outputs");
            System.exit(1);
        }
        String files = st.nextToken();
        if (!(files = files.trim()).startsWith("\"") || !files.endsWith("\"")) {
            System.err.println("Parse error processing outputs " + files);
            System.exit(1);
        }
        files.replaceAll("^\"", "");
        files.replaceAll("\"$", "");
        StringTokenizer st2 = new StringTokenizer(files, "\"");
        try {
            String file1 = st2.nextToken();
            st2.nextToken();
            String file2 = st2.nextToken();
            st2.nextToken();
            String file3 = st2.nextToken();
            Parameters.insertStringParameter("trainOutputFile", file1);
            Parameters.insertStringParameter("testOutputFile", file2);
            Parameters.insertStringParameter("logOutputFile", file3);
        }
        catch (NoSuchElementException e) {
            System.err.println("Parse error processing outputs " + files);
            System.exit(1);
        }
    }

    static void processParameters(StringTokenizer st, String paramName) {
        if (!st.hasMoreTokens()) {
            System.err.println("Parse error processing parameter " + paramName);
            System.exit(1);
        }
        String paramValue = st.nextToken();
        paramValue = paramValue.trim();
        System.out.println("paramName: " + paramName);
        if (Parameters.isReal(paramName)) {
            Parameters.insertRealParameter(paramName, paramValue);
        } else if (Parameters.isInteger(paramName)) {
            Parameters.insertIntegerParameter(paramName, paramValue);
        } else if (Parameters.isBoolean(paramName)) {
            Parameters.insertBooleanParameter(paramName, paramValue);
        } else if (Parameters.isString(paramName)) {
            Parameters.insertStringParameter(paramName, paramValue);
        } else {
            System.err.println("Unknown parameter " + paramName);
            System.exit(1);
        }
    }

    static boolean isReal(String paramName) {
        return paramName.equalsIgnoreCase("confidence");
    }

    static boolean isInteger(String paramName) {
        if (paramName.equalsIgnoreCase("numPartitions")) {
            return true;
        }
        if (paramName.equalsIgnoreCase("itemsetsPerLeaf")) {
            return true;
        }
        return paramName.equalsIgnoreCase("seed");
    }

    static boolean isBoolean(String paramName) {
        return paramName.equalsIgnoreCase("prune");
    }

    static boolean isString(String paramName) {
        return paramName.equalsIgnoreCase("filterType");
    }

    static void insertRealParameter(String paramName, String paramValue) {
        double num = Double.parseDouble(paramValue);
        try {
            Parameters param = new Parameters();
            Field f = Parameters.class.getField(paramName);
            f.setDouble(param, num);
        }
        catch (Exception e) {
            System.err.println("Cannot set param " + paramName);
            System.exit(1);
        }
    }

    static void insertIntegerParameter(String paramName, String paramValue) {
        int num = Integer.parseInt(paramValue);
        try {
            Parameters param = new Parameters();
            Field f = Parameters.class.getField(paramName);
            f.setInt(param, num);
        }
        catch (Exception e) {
            System.err.println("Cannot set param " + paramName);
            System.exit(1);
        }
    }

    static void insertBooleanParameter(String paramName, String paramValue) {
        boolean val = false;
        if (paramValue.equals("true")) {
            val = true;
        }
        try {
            Parameters param = new Parameters();
            Field f = Parameters.class.getField(paramName);
            f.setBoolean(param, val);
        }
        catch (Exception e) {
            System.err.println("Cannot set param " + paramName);
            System.exit(1);
        }
    }

    static void insertStringParameter(String paramName, String paramValue) {
        try {
            Parameters param = new Parameters();
            Field f = Parameters.class.getField(paramName);
            f.set(param, new String(paramValue));
        }
        catch (Exception e) {
            System.err.println("Cannot set param " + paramName);
            System.exit(1);
        }
    }

    static boolean validateAlgorithmName(String name) {
        return name.equalsIgnoreCase("IterativePartitioningFilter");
    }

    static String getLine() {
        String st = null;
        do {
            try {
                st = br.readLine();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        } while (st != null && st.equals(""));
        return st;
    }
}

