/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.BasicMethods;

import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.BasicMethods.RandomSelector;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class ARS
extends RandomSelector {
    public ARS(PrototypeSet t, int n) {
        super(t, n);
        this.algorithmName = "AdvancedRandomSelector";
    }

    public ARS(PrototypeSet t, Parameters params) {
        super(t, params);
        this.algorithmName = "AdvancedRandomSelector";
    }

    @Override
    public PrototypeSet reduceSet() {
        return super.selecRandomSet(this.numberOfPrototypesSelected, true);
    }

    public static void main(String[] args) {
        Parameters.setUse("AdvancedRandomSelector", "<seed> <number of prototypes>");
        Parameters.assertBasicArgs(args);
        ARS.setSeed(System.nanoTime() * 100L + System.nanoTime());
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        int n = Parameters.assertExtendedArgAsInt(args, 3, "number of prototypes", 1.0, training.size() - 1);
        ARS.setSeed(seed);
        ARS generator = new ARS(training, n);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

