/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.data.MatrixIterator32F;
import org.ejml.data.RealMatrix32F;
import org.ejml.data.ReshapeMatrix;

public abstract class D1Matrix32F
implements ReshapeMatrix,
RealMatrix32F {
    public float[] data;
    public int numRows;
    public int numCols;

    public float[] getData() {
        return this.data;
    }

    public void setData(float[] data) {
        this.data = data;
    }

    public abstract int getIndex(int var1, int var2);

    public void set(D1Matrix32F b) {
        this.reshape(b.numRows, b.numCols);
        int dataLength = b.getNumElements();
        System.arraycopy(b.data, 0, this.data, 0, dataLength);
    }

    public float get(int index) {
        return this.data[index];
    }

    public float set(int index, float val) {
        this.data[index] = val;
        return this.data[index];
    }

    public float plus(int index, float val) {
        int n = index;
        float f = this.data[n] + val;
        this.data[n] = f;
        return f;
    }

    public float minus(int index, float val) {
        int n = index;
        float f = this.data[n] - val;
        this.data[n] = f;
        return f;
    }

    public float times(int index, float val) {
        int n = index;
        float f = this.data[n] * val;
        this.data[n] = f;
        return f;
    }

    public float div(int index, float val) {
        int n = index;
        float f = this.data[n] / val;
        this.data[n] = f;
        return f;
    }

    public abstract void reshape(int var1, int var2, boolean var3);

    @Override
    public void reshape(int numRows, int numCols) {
        this.reshape(numRows, numCols, false);
    }

    public MatrixIterator32F iterator(boolean rowMajor, int minRow, int minCol, int maxRow, int maxCol) {
        return new MatrixIterator32F(this, rowMajor, minRow, minCol, maxRow, maxCol);
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public void setNumCols(int numCols) {
        this.numCols = numCols;
    }
}

