/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.oldevomodel.treelikelihood.LikelihoodCore;
import java.util.Arrays;

@Deprecated
public abstract class AbstractLikelihoodCore
implements LikelihoodCore {
    protected int stateCount;
    protected int nodeCount;
    protected int patternCount;
    protected int partialsSize;
    protected int matrixSize;
    protected int matrixCount;
    protected boolean integrateCategories;
    protected double[][][] partials;
    protected int[][] states;
    protected double[][][] matrices;
    protected int[] currentMatricesIndices;
    protected int[] storedMatricesIndices;
    protected int[] currentPartialsIndices;
    protected int[] storedPartialsIndices;
    protected boolean useScaling = false;
    protected double[][][] scalingFactors;
    private double scalingThreshold = 1.0E-100;

    public AbstractLikelihoodCore(int n) {
        this.stateCount = n;
    }

    @Override
    public void initialize(int n, int n2, int n3, boolean bl) {
        this.nodeCount = n;
        this.patternCount = n2;
        this.matrixCount = n3;
        this.integrateCategories = bl;
        this.partialsSize = bl ? n2 * this.stateCount * n3 : n2 * this.stateCount;
        this.partials = new double[2][n][];
        this.currentMatricesIndices = new int[n];
        this.storedMatricesIndices = new int[n];
        this.currentPartialsIndices = new int[n];
        this.storedPartialsIndices = new int[n];
        this.states = new int[n][];
        for (int i = 0; i < n; ++i) {
            this.partials[0][i] = null;
            this.partials[1][i] = null;
            this.states[i] = null;
        }
        this.matrixSize = this.stateCount * this.stateCount;
        this.matrices = new double[2][n][n3 * this.matrixSize];
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
        this.nodeCount = 0;
        this.patternCount = 0;
        this.matrixCount = 0;
        this.partials = null;
        this.currentPartialsIndices = null;
        this.storedPartialsIndices = null;
        this.states = null;
        this.matrices = null;
        this.currentMatricesIndices = null;
        this.storedMatricesIndices = null;
        this.scalingFactors = null;
    }

    @Override
    public void setUseScaling(boolean bl) {
        this.useScaling = bl;
        if (bl) {
            this.scalingFactors = new double[2][this.nodeCount][this.patternCount];
        }
    }

    @Override
    public void createNodePartials(int n) {
        this.partials[0][n] = new double[this.partialsSize];
        this.partials[1][n] = new double[this.partialsSize];
    }

    @Override
    public void setNodePartials(int n, double[] dArray) {
        if (this.partials[0][n] == null) {
            this.createNodePartials(n);
        }
        if (dArray.length < this.partialsSize) {
            int n2 = 0;
            for (int i = 0; i < this.matrixCount; ++i) {
                System.arraycopy(dArray, 0, this.partials[0][n], n2, dArray.length);
                n2 += dArray.length;
            }
        } else {
            System.arraycopy(dArray, 0, this.partials[0][n], 0, dArray.length);
        }
    }

    @Override
    public void createNodeStates(int n) {
        this.states[n] = new int[this.patternCount];
    }

    @Override
    public void setNodeStates(int n, int[] nArray) {
        if (this.states[n] == null) {
            this.createNodeStates(n);
        }
        System.arraycopy(nArray, 0, this.states[n], 0, this.patternCount);
    }

    public void getNodeStates(int n, int[] nArray) {
        System.arraycopy(this.states[n], 0, nArray, 0, this.patternCount);
    }

    @Override
    public void setNodeMatrixForUpdate(int n) {
        this.currentMatricesIndices[n] = 1 - this.currentMatricesIndices[n];
    }

    @Override
    public void setNodeMatrix(int n, int n2, double[] dArray) {
        System.arraycopy(dArray, 0, this.matrices[this.currentMatricesIndices[n]][n], n2 * this.matrixSize, this.matrixSize);
    }

    public void getNodeMatrix(int n, int n2, double[] dArray) {
        System.arraycopy(this.matrices[this.currentMatricesIndices[n]][n], n2 * this.matrixSize, dArray, 0, this.matrixSize);
    }

    @Override
    public void setNodePartialsForUpdate(int n) {
        this.currentPartialsIndices[n] = 1 - this.currentPartialsIndices[n];
    }

    @Override
    public void setCurrentNodePartials(int n, double[] dArray) {
        if (dArray.length < this.partialsSize) {
            int n2 = 0;
            for (int i = 0; i < this.matrixCount; ++i) {
                System.arraycopy(dArray, 0, this.partials[this.currentPartialsIndices[n]][n], n2, dArray.length);
                n2 += dArray.length;
            }
        } else {
            System.arraycopy(dArray, 0, this.partials[this.currentPartialsIndices[n]][n], 0, dArray.length);
        }
    }

    @Override
    public void calculatePartials(int n, int n2, int n3) {
        if (this.states[n] != null) {
            if (this.states[n2] != null) {
                this.calculateStatesStatesPruning(this.states[n], this.matrices[this.currentMatricesIndices[n]][n], this.states[n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n3]][n3]);
            } else {
                this.calculateStatesPartialsPruning(this.states[n], this.matrices[this.currentMatricesIndices[n]][n], this.partials[this.currentPartialsIndices[n2]][n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n3]][n3]);
            }
        } else if (this.states[n2] != null) {
            this.calculateStatesPartialsPruning(this.states[n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n]][n], this.matrices[this.currentMatricesIndices[n]][n], this.partials[this.currentPartialsIndices[n3]][n3]);
        } else {
            this.calculatePartialsPartialsPruning(this.partials[this.currentPartialsIndices[n]][n], this.matrices[this.currentMatricesIndices[n]][n], this.partials[this.currentPartialsIndices[n2]][n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n3]][n3]);
        }
        if (this.useScaling) {
            this.scalePartials(n3);
        }
    }

    protected abstract void calculateStatesStatesPruning(int[] var1, double[] var2, int[] var3, double[] var4, double[] var5);

    protected abstract void calculateStatesPartialsPruning(int[] var1, double[] var2, double[] var3, double[] var4, double[] var5);

    protected abstract void calculatePartialsPartialsPruning(double[] var1, double[] var2, double[] var3, double[] var4, double[] var5);

    @Override
    public void calculatePartials(int n, int n2, int n3, int[] nArray) {
        if (this.states[n] != null) {
            if (this.states[n2] != null) {
                this.calculateStatesStatesPruning(this.states[n], this.matrices[this.currentMatricesIndices[n]][n], this.states[n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n3]][n3], nArray);
            } else {
                this.calculateStatesPartialsPruning(this.states[n], this.matrices[this.currentMatricesIndices[n]][n], this.partials[this.currentPartialsIndices[n2]][n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n3]][n3], nArray);
            }
        } else if (this.states[n2] != null) {
            this.calculateStatesPartialsPruning(this.states[n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n]][n], this.matrices[this.currentMatricesIndices[n]][n], this.partials[this.currentPartialsIndices[n3]][n3], nArray);
        } else {
            this.calculatePartialsPartialsPruning(this.partials[this.currentPartialsIndices[n]][n], this.matrices[this.currentMatricesIndices[n]][n], this.partials[this.currentPartialsIndices[n2]][n2], this.matrices[this.currentMatricesIndices[n2]][n2], this.partials[this.currentPartialsIndices[n3]][n3], nArray);
        }
        if (this.useScaling) {
            this.scalePartials(n3);
        }
    }

    protected abstract void calculateStatesStatesPruning(int[] var1, double[] var2, int[] var3, double[] var4, double[] var5, int[] var6);

    protected abstract void calculateStatesPartialsPruning(int[] var1, double[] var2, double[] var3, double[] var4, double[] var5, int[] var6);

    protected abstract void calculatePartialsPartialsPruning(double[] var1, double[] var2, double[] var3, double[] var4, double[] var5, int[] var6);

    @Override
    public void integratePartials(int n, double[] dArray, double[] dArray2) {
        this.calculateIntegratePartials(this.partials[this.currentPartialsIndices[n]][n], dArray, dArray2);
    }

    protected abstract void calculateIntegratePartials(double[] var1, double[] var2, double[] var3);

    protected void scalePartials(int n) {
        int n2 = 0;
        for (int i = 0; i < this.patternCount; ++i) {
            int n3;
            int n4;
            double d = 0.0;
            int n5 = n2;
            for (n4 = 0; n4 < this.matrixCount; ++n4) {
                for (n3 = 0; n3 < this.stateCount; ++n3) {
                    if (this.partials[this.currentPartialsIndices[n]][n][n5] > d) {
                        d = this.partials[this.currentPartialsIndices[n]][n][n5];
                    }
                    ++n5;
                }
                n5 += (this.patternCount - 1) * this.stateCount;
            }
            if (d < this.scalingThreshold) {
                n5 = n2;
                for (n4 = 0; n4 < this.matrixCount; ++n4) {
                    for (n3 = 0; n3 < this.stateCount; ++n3) {
                        double[] dArray = this.partials[this.currentPartialsIndices[n]][n];
                        int n6 = n5++;
                        dArray[n6] = dArray[n6] / d;
                    }
                    n5 += (this.patternCount - 1) * this.stateCount;
                }
                this.scalingFactors[this.currentPartialsIndices[n]][n][i] = Math.log(d);
            } else {
                this.scalingFactors[this.currentPartialsIndices[n]][n][i] = 0.0;
            }
            n2 += this.stateCount;
        }
    }

    @Override
    public double getLogScalingFactor(int n) {
        double d = 0.0;
        if (this.useScaling) {
            for (int i = 0; i < this.nodeCount; ++i) {
                d += this.scalingFactors[this.currentPartialsIndices[i]][i][n];
            }
        }
        return d;
    }

    @Override
    public void getLogScalingFactors(int n, double[] dArray) {
        if (this.useScaling) {
            System.arraycopy(this.scalingFactors[this.currentPartialsIndices[n]][n], 0, dArray, 0, this.patternCount);
        } else {
            Arrays.fill(dArray, 0.0);
        }
    }

    @Override
    public boolean arePartialsRescaled() {
        return this.useScaling;
    }

    @Override
    public void getPartials(int n, double[] dArray) {
        double[] dArray2 = this.partials[this.currentPartialsIndices[n]][n];
        System.arraycopy(dArray2, 0, dArray, 0, this.partialsSize);
    }

    @Override
    public void storeState() {
        System.arraycopy(this.currentMatricesIndices, 0, this.storedMatricesIndices, 0, this.nodeCount);
        System.arraycopy(this.currentPartialsIndices, 0, this.storedPartialsIndices, 0, this.nodeCount);
    }

    @Override
    public void restoreState() {
        int[] nArray = this.currentMatricesIndices;
        this.currentMatricesIndices = this.storedMatricesIndices;
        this.storedMatricesIndices = nArray;
        int[] nArray2 = this.currentPartialsIndices;
        this.currentPartialsIndices = this.storedPartialsIndices;
        this.storedPartialsIndices = nArray2;
    }
}

