/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.distribution.RandomField;
import dr.inference.distribution.shrinkage.BayesianBridgeStatisticsProvider;
import dr.inference.distribution.shrinkage.JointBayesianBridgeDistributionModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.math.distributions.GaussianMarkovRandomField;

public class BayesianBridgeMarkovRandomField
extends GaussianMarkovRandomField
implements BayesianBridgeStatisticsProvider {
    public static final String TYPE = "BayesianBridgeMarkovRandomField";
    private final JointBayesianBridgeDistributionModel bayesianBridge;

    public BayesianBridgeMarkovRandomField(String string, JointBayesianBridgeDistributionModel jointBayesianBridgeDistributionModel, Parameter parameter, RandomField.WeightProvider weightProvider, boolean bl) {
        super(string, jointBayesianBridgeDistributionModel.getDimension(), null, parameter, null, weightProvider, bl);
        this.bayesianBridge = jointBayesianBridgeDistributionModel;
        this.addModel(jointBayesianBridgeDistributionModel);
    }

    @Override
    protected GaussianMarkovRandomField.SymmetricTriDiagonalMatrix getQ() {
        if (!this.qKnown) {
            double[] dArray = this.Q.diagonal;
            double[] dArray2 = this.Q.offDiagonal;
            double d = this.bayesianBridge.getStandardDeviation(0);
            dArray2[0] = -1.0 / (d * d);
            dArray[0] = -dArray2[0];
            for (int i = 1; i < this.dim - 1; ++i) {
                d = this.bayesianBridge.getStandardDeviation(i);
                dArray2[i] = -1.0 / (d * d);
                dArray[i] = -(dArray2[i - 1] + dArray2[i]);
            }
            dArray[this.dim - 1] = -dArray2[this.dim - 2];
            this.qKnown = true;
        }
        return this.Q;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model != this.bayesianBridge) {
            throw new IllegalArgumentException("Unknown model");
        }
        this.qKnown = false;
    }

    @Override
    public double getCoefficient(int n) {
        throw new RuntimeException("Should never call");
    }

    @Override
    public Parameter getGlobalScale() {
        return this.bayesianBridge.getGlobalScale();
    }

    @Override
    public Parameter getLocalScale() {
        return this.bayesianBridge.getLocalScale();
    }

    @Override
    public Parameter getExponent() {
        return this.bayesianBridge.getExponent();
    }

    @Override
    public Parameter getSlabWidth() {
        return this.bayesianBridge.getSlabWidth();
    }
}

