/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.GradientProvider;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;

public class TruncatedSoftBoundCauchyDistribution
extends AbstractContinuousDistribution
implements Distribution,
GradientProvider,
Citable {
    private final double lowerBound;
    private final double offSetProportion;
    private final double scaleMultiplier;
    private final double tailL;
    private final double A;
    private final double t0;
    private final double s;
    public static Citation CITATION = new Citation(new Author[]{new Author("J", "Inoue"), new Author("PCJ", "Donoghue"), new Author("Z", "Yang")}, "The impact of the representation of fossil calibrations on Bayesian estimation of species divergence times", 2010, "Systematic Biology", 59, 74, 89, Citation.Status.PUBLISHED);

    public TruncatedSoftBoundCauchyDistribution(double d, double d2, double d3) {
        this(d, d2, d3, 0.025);
    }

    public TruncatedSoftBoundCauchyDistribution(double d, double d2, double d3, double d4) {
        this.lowerBound = d;
        this.offSetProportion = d2;
        this.scaleMultiplier = d3;
        this.tailL = d4;
        this.A = 0.5 + 0.3183098861837907 * Math.atan2(d3, d2);
        this.t0 = d * (1.0 + d2);
        this.s = d * d3;
    }

    @Override
    public double pdf(double d) {
        assert (d > 0.0);
        if (d > this.lowerBound) {
            double d2 = (d - this.t0) / this.s;
            return (1.0 - this.tailL) / (Math.PI * this.A * this.s * (1.0 + d2 * d2));
        }
        double d3 = this.offSetProportion / this.scaleMultiplier;
        double d4 = (1.0 / this.tailL - 1.0) / (Math.PI * this.A * this.scaleMultiplier * (1.0 + d3 * d3));
        return this.tailL * d4 / this.lowerBound * Math.pow(d / this.lowerBound, d4 - 1.0);
    }

    @Override
    public double logPdf(double d) {
        assert (d > 0.0);
        if (d > this.lowerBound) {
            double d2 = (d - this.t0) / this.s;
            return Math.log((1.0 - this.tailL) / (Math.PI * this.A * this.s * (1.0 + d2 * d2)));
        }
        double d3 = this.offSetProportion / this.scaleMultiplier;
        double d4 = (1.0 / this.tailL - 1.0) / (Math.PI * this.A * this.scaleMultiplier * (1.0 + d3 * d3));
        return Math.log(this.tailL * d4 / this.lowerBound) + (d4 - 1.0) * Math.log(d / this.lowerBound);
    }

    @Override
    public double cdf(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    protected double getInitialDomain(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    protected double getDomainLowerBound(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    protected double getDomainUpperBound(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.PRIOR_MODELS;
    }

    @Override
    public String getDescription() {
        return "Truncated Cauchy distribution with soft bound.";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double d = (Double)object;
        assert (d > 0.0);
        if (d > this.lowerBound) {
            double d2 = (d - this.t0) / this.s;
            return new double[]{-2.0 * d2 / (1.0 + d2 * d2) / this.s};
        }
        double d3 = this.offSetProportion / this.scaleMultiplier;
        double d4 = (1.0 / this.tailL - 1.0) / (Math.PI * this.A * this.scaleMultiplier * (1.0 + d3 * d3));
        return new double[]{(d4 - 1.0) / d};
    }
}

